/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.typicals.rules;

import gnu.trove.set.hash.THashSet;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.typicals.ITypicalSynchronizationRule;
import org.simantics.modeling.typicals.TypicalInfo;
import org.simantics.modeling.typicals.rules.Properties;
import org.simantics.utils.ui.ErrorLogger;

public enum FlagRule implements ITypicalSynchronizationRule
{
    INSTANCE;


    public static FlagRule getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean synchronize(WriteGraph graph, Resource template, Resource instance, TypicalInfo info) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        boolean changed = false;
        boolean result = Properties.synchronizeEnumerationPropertyValue(graph, template, instance, DIA.HasFlagType);
        if (result) {
            info.messageLog.add("\t\t\tflag type");
        }
        changed |= result;
        result = Properties.synchronizeTag(graph, template, instance, DIA.ExternalFlag);
        if (result) {
            info.messageLog.add("\t\t\texternal status");
        }
        changed |= result;
        result = Properties.synchronizePrimitivePropertyValue(graph, template, instance, DIA.Flag_HasIOTableBinding);
        if (result) {
            info.messageLog.add("\t\t\tIO table binding");
        }
        changed |= result;
        result = Properties.synchronizePrimitivePropertyValue(graph, template, instance, DIA.Flag_HasIOTableRowIndex);
        if (result) {
            info.messageLog.add("\t\t\tIO table row");
        }
        changed |= result;
        return changed |= this.synchronizeJoins(graph, template, instance, info);
    }

    public boolean synchronizeJoins(WriteGraph graph, Resource template, Resource instance, TypicalInfo info) throws DatabaseException {
        boolean changed = false;
        Set tCounterparts = FlagUtil.getCounterparts((ReadGraph)graph, (Resource)template, (Set)new THashSet(2));
        Set iCounterparts = FlagUtil.getCounterparts((ReadGraph)graph, (Resource)instance, (Set)new THashSet(2));
        if (tCounterparts.isEmpty() && iCounterparts.isEmpty()) {
            return false;
        }
        for (Resource tCounterpart : tCounterparts) {
            if (!info.bean.templateElements.contains(tCounterpart)) {
                ErrorLogger.defaultLogWarning((String)("Encountered flag " + NameUtils.getSafeName((ReadGraph)graph, (Resource)template, (boolean)true) + " in a typical template diagram with an invalid flag reference to correspondence " + NameUtils.getSafeName((ReadGraph)graph, (Resource)tCounterpart, (boolean)true)), (Throwable)new Exception("trace"));
                continue;
            }
            Resource i = info.bean.templateToInstance.get(tCounterpart);
            if (i == null) {
                ErrorLogger.defaultLogError((String)("Encountered flag " + NameUtils.getSafeName((ReadGraph)graph, (Resource)template, (boolean)true) + " in a typical template diagram while the instance diagram flag " + NameUtils.getSafeName((ReadGraph)graph, (Resource)instance, (boolean)true) + " does not contain an element mapped to template flag correspondence " + NameUtils.getSafeName((ReadGraph)graph, (Resource)tCounterpart, (boolean)true)), (Throwable)new Exception("trace"));
                continue;
            }
            if (iCounterparts.remove(i)) continue;
            FlagUtil.join((WriteGraph)graph, (Resource)instance, (Resource)i);
            info.messageLog.add("\t\t\tsynchronized join " + NameUtils.getSafeName((ReadGraph)graph, (Resource)i));
            changed = true;
        }
        for (Resource iCounterpart : iCounterparts) {
            FlagUtil.disconnectFlag((WriteGraph)graph, (Resource)instance, (Resource)iCounterpart);
            info.messageLog.add("\t\t\tdisconnected flag " + NameUtils.getSafeName((ReadGraph)graph, (Resource)iCounterpart));
            changed = true;
        }
        return changed;
    }
}

