/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.typicals;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.simantics.db.event.ChangeListener;
import org.simantics.db.service.GraphChangeListenerSupport;
import org.simantics.modeling.typicals.TypicalDiagramTemplateListener;
import org.simantics.project.IProject;

public class TypicalSupport {
    protected IProject project;
    protected GraphChangeListenerSupport changeListenerSupport;
    private IEclipsePreferences typicalPreferences;
    private TypicalDiagramTemplateListener typicalDiagramTemplateListener;
    private IEclipsePreferences.IPreferenceChangeListener typicalSynchronizationPreferenceListener = new TypicalSynchronizationPreferenceListener();

    public TypicalSupport(IProject project) {
        this.project = project;
        this.changeListenerSupport = (GraphChangeListenerSupport)project.getSession().getService(GraphChangeListenerSupport.class);
        this.setTypicalSynchronization(this.isSyncEnabled());
        this.typicalPreferences = InstanceScope.INSTANCE.getNode("org.simantics.modeling");
        this.typicalPreferences.addPreferenceChangeListener(this.typicalSynchronizationPreferenceListener);
    }

    public void dispose() {
        if (this.typicalPreferences != null) {
            this.typicalPreferences.removePreferenceChangeListener(this.typicalSynchronizationPreferenceListener);
        }
        if (this.typicalDiagramTemplateListener != null) {
            this.changeListenerSupport.removeMetadataListener((ChangeListener)this.typicalDiagramTemplateListener);
            this.typicalDiagramTemplateListener = null;
        }
    }

    public void setTypicalSynchronization(boolean enabled) {
        if (enabled) {
            if (this.typicalDiagramTemplateListener == null) {
                this.typicalDiagramTemplateListener = new TypicalDiagramTemplateListener();
                this.changeListenerSupport.addMetadataListener((ChangeListener)this.typicalDiagramTemplateListener);
            }
        } else if (this.typicalDiagramTemplateListener != null) {
            this.changeListenerSupport.removeMetadataListener((ChangeListener)this.typicalDiagramTemplateListener);
            this.typicalDiagramTemplateListener = null;
        }
    }

    private boolean isSyncEnabled() {
        return InstanceScope.INSTANCE.getNode("org.simantics.modeling").getBoolean("typical.sync.realtime", false);
    }

    private class TypicalSynchronizationPreferenceListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private TypicalSynchronizationPreferenceListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (TypicalSupport.this.project == null || TypicalSupport.this.project.isDisposed()) {
                return;
            }
            if ("typical.sync.realtime".equals(event.getKey())) {
                boolean enabled = TypicalSupport.this.isSyncEnabled();
                TypicalSupport.this.setTypicalSynchronization(enabled);
            }
        }
    }
}

