/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.subscription;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;

public class SubscriptionItemsQuery
extends UniqueRead<Set<Resource>> {
    Collection<Resource> resources;

    public SubscriptionItemsQuery(Collection<Resource> resources) {
        this.resources = resources;
    }

    public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
        HashSet<Resource> result = new HashSet<Resource>();
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource r : this.resources) {
            if (graph.isInstanceOf(r, MOD.Subscription_Item)) {
                result.add(r);
                continue;
            }
            if (!graph.isInstanceOf(r, MOD.Subscription)) continue;
            for (Resource rr : graph.getObjects(r, L0.ConsistsOf)) {
                if (!graph.isInstanceOf(rr, MOD.Subscription_Item)) continue;
                result.add(rr);
            }
        }
        return result;
    }
}

