/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.subscription;

import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;

public class FindSubscriptionItem
extends UniqueRead<Resource> {
    Resource subscription;
    RVI rvi;

    public FindSubscriptionItem(Resource subscription, RVI rvi) {
        this.subscription = subscription;
        this.rvi = rvi;
    }

    public Resource perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Binding rviBinding = ((Databoard)graph.getService(Databoard.class)).getBindingUnchecked(RVI.class);
        for (Resource r : graph.getObjects(this.subscription, L0.ConsistsOf)) {
            RVI _rvi;
            if (!graph.isInstanceOf(r, MOD.Subscription_Item) || !(_rvi = (RVI)graph.getPossibleRelatedValue(r, MOD.Subscription_Item_VariableId, rviBinding)).equals((Object)this.rvi)) continue;
            return r;
        }
        return null;
    }

    public int hashCode() {
        return this.rvi.hashCode() + this.subscription.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        FindSubscriptionItem r = (FindSubscriptionItem)((Object)object);
        return this.subscription.equals(r.subscription) && this.rvi.equals((Object)r.rvi);
    }
}

