/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.services;

import gnu.trove.map.hash.THashMap;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.AsyncReadRequest;
import org.simantics.db.event.ChangeEvent;
import org.simantics.db.event.ChangeListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.service.GraphChangeListenerSupport;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ComponentUtils;
import org.simantics.modeling.services.ComponentNamingStrategy;
import org.simantics.modeling.services.ComponentNamingStrategyBase;
import org.simantics.modeling.services.NamingException;
import org.simantics.project.IProject;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.ErrorLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseInsensitiveComponentNamingStrategy2
extends ComponentNamingStrategyBase
implements ChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseInsensitiveComponentNamingStrategy2.class);
    private static final boolean DEBUG_ALL = false;
    private static final boolean DEBUG_GRAPH_UPDATES = false;
    private static final boolean DEBUG_CACHE_INITIALIZATION = false;
    private static final boolean DEBUG_CACHE_INITIALIZATION_BROWSE = false;
    private static final boolean DEBUG_CACHE_UPDATES = false;
    private SoftReference<THashMap<Resource, SoftReference<Cache>>> mapRef = new SoftReference<THashMap>(new THashMap());
    private final GraphChangeListenerSupport changeSupport;
    private Resource inverseOfHasName;

    public CaseInsensitiveComponentNamingStrategy2() {
        this((GraphChangeListenerSupport)Simantics.getSession().getService(GraphChangeListenerSupport.class), "%s_%d");
    }

    public CaseInsensitiveComponentNamingStrategy2(GraphChangeListenerSupport changeSupport) {
        this(changeSupport, "%s %d");
    }

    public CaseInsensitiveComponentNamingStrategy2(GraphChangeListenerSupport changeSupport, String generatedNameFormat) {
        super(generatedNameFormat);
        this.changeSupport = changeSupport;
        changeSupport.addListener((ChangeListener)this);
    }

    public void dispose() {
        this.changeSupport.removeListener((ChangeListener)this);
    }

    public void graphChanged(ChangeEvent e) throws DatabaseException {
        Collection changedValues = e.getChanges().changedValues();
        ReadGraph graph = e.getGraph();
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        if (this.inverseOfHasName == null) {
            this.inverseOfHasName = graph.getInverse(b.HasName);
        }
        CacheUpdateBundle bundle = new CacheUpdateBundle();
        for (Resource value : changedValues) {
            for (Resource nameOfComponent : graph.getObjects(value, this.inverseOfHasName)) {
                String newName;
                Resource root = ComponentUtils.tryGetComponentConfigurationRoot(graph, nameOfComponent);
                Cache cache = this.peekCache(graph, root);
                if (cache == null || (newName = (String)graph.getPossibleValue(value, (Binding)Bindings.STRING)) == null) continue;
                bundle.add(cache, nameOfComponent, newName);
            }
        }
        if (!bundle.isEmpty()) {
            bundle.commitAll();
        }
    }

    private Cache getCache(ReadGraph graph, Resource configurationRoot) throws DatabaseException {
        Cache cache = null;
        THashMap map = this.mapRef.get();
        if (map != null) {
            SoftReference cacheRef = (SoftReference)map.get((Object)configurationRoot);
            if (cacheRef != null && (cache = (Cache)cacheRef.get()) != null) {
                return cache;
            }
        } else {
            map = new THashMap();
            this.mapRef = new SoftReference<THashMap>(map);
        }
        cache = new CacheFactory(graph, configurationRoot, this.caseInsensitive).create();
        map.put((Object)configurationRoot, new SoftReference<Cache>(cache));
        return cache;
    }

    private Cache peekCache(ReadGraph graph, Resource configurationRoot) {
        THashMap<Resource, SoftReference<Cache>> map = this.mapRef.get();
        if (map == null) {
            return null;
        }
        SoftReference cacheRef = (SoftReference)map.get((Object)configurationRoot);
        if (cacheRef == null) {
            return null;
        }
        Cache cache = (Cache)cacheRef.get();
        if (cache == null) {
            return null;
        }
        return cache;
    }

    @Override
    public String validateInstanceName(ReadGraph graph, Resource configurationRoot, Resource component, String proposition, boolean acceptProposition) throws NamingException, DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource container = graph.getSingleObject(component, L0.PartOf);
        Resource componentType = graph.getSingleType(component, STR.Component);
        return this.validateInstanceName(graph, configurationRoot, container, componentType, proposition, acceptProposition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String validateInstanceName(ReadGraph graph, Resource configurationRoot, Resource container, Resource componentType, String proposition, boolean acceptProposition) throws NamingException, DatabaseException {
        Cache cache;
        Cache cache2 = cache = this.getCache(graph, configurationRoot);
        synchronized (cache2) {
            String result = this.findFreshName(cache.getReserved(), cache.getRequested(), proposition, acceptProposition);
            cache.addRequested(result);
            return result;
        }
    }

    private void debug(String string) {
        CaseInsensitiveComponentNamingStrategy2.debug(this, string);
    }

    private static void debug(Object obj, String string) {
        System.out.println("[" + obj.getClass().getSimpleName() + "(" + System.identityHashCode(obj) + ")] " + string);
    }

    private static <K, V> Set<V> addToMapSet(ConcurrentMap<K, Set<V>> map, K key, V value) {
        HashSet<V> set = (HashSet<V>)map.get(key);
        if (set == null) {
            set = new HashSet<V>(1);
            map.putIfAbsent(key, set);
        }
        set.add(value);
        return set;
    }

    private static <K, V> Set<V> getMapSet(ConcurrentMap<K, Set<V>> map, K key) {
        Set set = (Set)map.get(key);
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    private static <K, V> Set<V> removeFromMapSet(ConcurrentMap<K, Set<V>> map, K key, V value) {
        Set set = (Set)map.get(key);
        if (set == null) {
            return Collections.emptySet();
        }
        if (set.remove(value) && set.isEmpty()) {
            map.remove(key);
            return Collections.emptySet();
        }
        return set;
    }

    public static CaseInsensitiveComponentNamingStrategy2 install(IProject project) {
        Session session = project.getSession();
        GraphChangeListenerSupport changeSupport = (GraphChangeListenerSupport)session.peekService(GraphChangeListenerSupport.class);
        if (changeSupport != null) {
            CaseInsensitiveComponentNamingStrategy2 namingStrategy = new CaseInsensitiveComponentNamingStrategy2(changeSupport, "%s%02d");
            project.setHint(ComponentNamingStrategy.PROJECT_KEY, (Object)namingStrategy);
            return namingStrategy;
        }
        System.out.println("WARNING: No GraphChangeListenerSupport in session " + String.valueOf(session) + ", can't initialize all services.");
        return null;
    }

    static class Cache {
        private final Resource root;
        private final Set<String> reserved;
        private final Set<String> requested;
        private final ConcurrentMap<Resource, String> r2s;
        private final ConcurrentMap<String, Set<Resource>> s2r;

        public Cache(Resource root, Set<String> reserved, ConcurrentMap<Resource, String> r2s, ConcurrentMap<String, Set<Resource>> s2r, boolean caseInsensitive) {
            assert (root != null);
            assert (reserved != null);
            assert (r2s != null);
            assert (s2r != null);
            this.root = root;
            this.reserved = reserved;
            this.r2s = r2s;
            this.s2r = s2r;
            this.requested = new ConcurrentSkipListSet<Object>(CaseInsensitiveComponentNamingStrategy2.getComparator(caseInsensitive));
        }

        protected void finalize() throws Throwable {
            super.finalize();
        }

        public Resource getRoot() {
            return this.root;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<String> getReserved() {
            Cache cache = this;
            synchronized (cache) {
                return this.reserved;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<String> getRequested() {
            Cache cache = this;
            synchronized (cache) {
                return this.requested;
            }
        }

        public void addRequested(String name) {
            this.requested.add(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void replaceEntries(Collection<Pair<Resource, String>> entries) {
            if (entries.isEmpty()) {
                return;
            }
            Cache cache = this;
            synchronized (cache) {
                for (Pair<Resource, String> entry : entries) {
                    Set<Resource> existingEntries;
                    Resource component = (Resource)entry.first;
                    String newName = (String)entry.second;
                    assert (component != null);
                    assert (newName != null);
                    String oldName = (String)this.r2s.get(component);
                    if (oldName == null) {
                        existingEntries = CaseInsensitiveComponentNamingStrategy2.getMapSet(this.s2r, newName);
                        if (!existingEntries.isEmpty()) {
                            System.out.println("WARNING: Somebody is screwing the model up with duplicate name: " + newName);
                        }
                        String prev = this.r2s.putIfAbsent(component, newName);
                        assert (prev == null);
                        CaseInsensitiveComponentNamingStrategy2.addToMapSet(this.s2r, newName, component);
                        this.reserved.add(newName);
                        this.requested.remove(newName);
                        continue;
                    }
                    existingEntries = CaseInsensitiveComponentNamingStrategy2.getMapSet(this.s2r, newName);
                    if (!existingEntries.isEmpty()) {
                        if (existingEntries.contains(component)) continue;
                        System.out.println("WARNING: Somebody is screwing the model up with duplicate name: " + newName);
                    }
                    Set<Resource> resourcesWithOldName = CaseInsensitiveComponentNamingStrategy2.removeFromMapSet(this.s2r, oldName, component);
                    CaseInsensitiveComponentNamingStrategy2.addToMapSet(this.s2r, newName, component);
                    boolean updated = this.r2s.replace(component, oldName, newName);
                    assert (updated);
                    if (resourcesWithOldName.isEmpty()) {
                        this.reserved.remove(oldName);
                    }
                    this.reserved.add(newName);
                    this.requested.remove(newName);
                }
            }
        }

        private void debug(String string) {
            CaseInsensitiveComponentNamingStrategy2.debug(this, string);
        }
    }

    static class CacheFactory {
        final ReadGraph graph;
        final Resource root;
        final Layer0 b;
        final StructuralResource2 sr;
        final boolean caseInsensitive;
        final Set<String> reserved;
        final ConcurrentMap<Resource, String> r2s = new ConcurrentSkipListMap<Resource, String>();
        final ConcurrentMap<String, Set<Resource>> s2r;

        CacheFactory(ReadGraph graph, Resource root, boolean caseInsensitive) {
            this.graph = graph;
            this.root = root;
            this.b = Layer0.getInstance((ReadGraph)graph);
            this.sr = StructuralResource2.getInstance((ReadGraph)graph);
            this.caseInsensitive = caseInsensitive;
            this.reserved = new ConcurrentSkipListSet<Object>(CaseInsensitiveComponentNamingStrategy2.getComparator(caseInsensitive));
            this.s2r = new ConcurrentSkipListMap<Object, Set<Resource>>(CaseInsensitiveComponentNamingStrategy2.getComparator(caseInsensitive));
        }

        private void debug(String string) {
            CaseInsensitiveComponentNamingStrategy2.debug(this, string);
        }

        public Cache create() throws DatabaseException {
            this.graph.syncRequest((AsyncRead)new AsyncReadRequest(){

                public void run(AsyncReadGraph graph) {
                    this.browseComposite(graph, root);
                }
            });
            return new Cache(this.root, this.reserved, this.r2s, this.s2r, this.caseInsensitive);
        }

        private void browseComposite(AsyncReadGraph graph, Resource composite) {
            graph.forEachObject(composite, this.b.ConsistsOf, (AsyncMultiProcedure)new MultiProc<Resource>(){

                public void execute(AsyncReadGraph graph, Resource component) {
                    this.browseComponent(graph, component);
                }

                private void browseComponent(AsyncReadGraph graph, final Resource component) {
                    this.reserveName(graph, component);
                    graph.forIsInstanceOf(component, sr.Composite, (AsyncProcedure)new AsyncProc<Boolean>(){

                        public void execute(AsyncReadGraph graph, Boolean result) {
                            if (result.booleanValue()) {
                                this.browseComposite(graph, component);
                            }
                        }
                    });
                }

                private void reserveName(AsyncReadGraph graph, final Resource component) {
                    graph.forPossibleRelatedValue(component, b.HasName, (AsyncProcedure)new AsyncProc<String>(){

                        public void execute(AsyncReadGraph graph, String componentName) {
                            if (componentName != null) {
                                Set<Resource> components = CaseInsensitiveComponentNamingStrategy2.addToMapSet(s2r, componentName, component);
                                if (components.size() > 1) {
                                    LOGGER.warn("WARNING: found multiple components with same name '" + componentName + "': " + String.valueOf(components));
                                    LOGGER.warn("TODO: generate issue");
                                } else {
                                    String prevName = r2s.putIfAbsent(component, componentName);
                                    if (prevName == null) {
                                        reserved.add(componentName);
                                    }
                                }
                            }
                        }
                    });
                }
            });
        }

        static abstract class AsyncProc<T>
        implements AsyncProcedure<T> {
            AsyncProc() {
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                ErrorLogger.defaultLogError((Throwable)t);
            }
        }

        static abstract class MultiProc<T>
        implements AsyncMultiProcedure<T> {
            MultiProc() {
            }

            public void finished(AsyncReadGraph graph) {
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                ErrorLogger.defaultLogError((Throwable)t);
            }
        }
    }

    static class CacheUpdateBundle {
        IdentityHashMap<Cache, Collection<Pair<Resource, String>>> updates = new IdentityHashMap();

        CacheUpdateBundle() {
        }

        public boolean isEmpty() {
            return this.updates.isEmpty();
        }

        public void add(Cache cache, Resource component, String newName) {
            assert (cache != null);
            assert (component != null);
            assert (newName != null);
            Collection<Pair<Resource, String>> collection = this.updates.get(cache);
            if (collection == null) {
                collection = new ArrayList<Pair<Resource, String>>();
                this.updates.put(cache, collection);
            }
            collection.add((Pair<Resource, String>)Pair.make((Object)component, (Object)newName));
        }

        public void commitAll() {
            for (Map.Entry<Cache, Collection<Pair<Resource, String>>> entry : this.updates.entrySet()) {
                Cache cache = entry.getKey();
                cache.replaceEntries(entry.getValue());
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [" + this.updates.size() + " changed caches]";
        }
    }
}

