/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.scl;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteGraphMatching {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteGraphMatching.class);
    public static boolean TRACE = false;

    public static List<Resource> matchRouteGraph(ReadGraph graph, List<Resource> connectors, int routeLineCount, List<Integer> links) throws DatabaseException {
        MatchingProcess process = new MatchingProcess(graph, connectors.size() + routeLineCount);
        int i = 0;
        while (i < links.size()) {
            process.addLink(links.get(i), links.get(i + 1));
            i += 2;
        }
        if (!process.match(connectors)) {
            return null;
        }
        return Arrays.asList(process.result);
    }

    private static class Link {
        public final int a;
        public final int b;

        public Link(int a, int b) {
            this.a = a;
            this.b = b;
        }
    }

    private static class MatchingProcess {
        ReadGraph graph;
        DiagramResource DIA;
        Resource[] result;
        ArrayList<Link>[] ls;
        ArrayList<Resource>[] alternatives;
        TIntArrayList stack = new TIntArrayList();
        THashSet<Resource> knownResources = new THashSet();

        public MatchingProcess(ReadGraph graph, int size) {
            this.graph = graph;
            this.DIA = DiagramResource.getInstance((ReadGraph)graph);
            this.result = new Resource[size];
            this.ls = new ArrayList[size];
            this.alternatives = new ArrayList[size];
            int i = 0;
            while (i < size) {
                this.ls[i] = new ArrayList(2);
                ++i;
            }
        }

        public void addLink(int a, int b) {
            Link link = new Link(a, b);
            this.ls[link.a].add(link);
            this.ls[link.b].add(link);
        }

        /*
         * Exception decompiling
         */
        public boolean match(List<Resource> known) throws DatabaseException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AnonBreakTarget
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean removeKnownResourcesFromAlternatives() throws DatabaseException {
            int i = 0;
            while (i < this.result.length) {
                ArrayList<Resource> alt = this.alternatives[i];
                if (alt != null) {
                    alt.removeAll((Collection<?>)this.knownResources);
                    if (alt.isEmpty()) {
                        return false;
                    }
                    if (alt.size() == 1) {
                        this.result[i] = alt.get(0);
                        this.alternatives[i] = null;
                        this.stack.add(i);
                    }
                }
                ++i;
            }
            return true;
        }

        private void printState() {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.result.length) {
                sb.append("    {" + i + "} ");
                if (this.result[i] != null) {
                    sb.append(" = " + this.result[i].getResourceId());
                } else if (this.alternatives[i] != null) {
                    sb.append(" in");
                    for (Resource r : this.alternatives[i]) {
                        sb.append(" " + r.getResourceId());
                    }
                } else {
                    sb.append(" unknown");
                }
                if (!this.ls[i].isEmpty()) {
                    sb.append(", links to");
                    for (Link l : this.ls[i]) {
                        sb.append(" " + (l.a == i ? l.b : l.a));
                    }
                }
                sb.append('\n');
                ++i;
            }
            LOGGER.info(sb.toString());
        }

        private boolean propagate(int pos) throws DatabaseException {
            if (TRACE) {
                System.out.println("propagate(" + pos + ")");
            }
            Resource r = this.result[pos];
            this.knownResources.add((Object)r);
            ArrayList<Resource> neighbors = new ArrayList<Resource>(this.graph.getObjects(r, this.DIA.AreConnected));
            neighbors.removeAll((Collection<?>)this.knownResources);
            for (Link link : this.ls[pos]) {
                int other = link.a == pos ? link.b : link.a;
                this.ls[other].remove(link);
                if (this.setAlternatives(other, neighbors)) continue;
                return false;
            }
            this.ls[pos].clear();
            return true;
        }

        private boolean setKnown(int i, Resource value) throws DatabaseException {
            if (TRACE) {
                System.out.println("setKnown(" + i + ", " + String.valueOf(value) + ")");
            }
            if (this.result[i] != null) {
                return this.result[i].equals(value);
            }
            if (this.alternatives[i] != null) {
                if (!this.alternatives[i].contains(value)) {
                    return false;
                }
                this.alternatives[i] = null;
            }
            this.result[i] = value;
            this.stack.add(i);
            return true;
        }

        private boolean setAlternatives(int i, Collection<Resource> values) throws DatabaseException {
            if (TRACE) {
                System.out.println("setAlternatives(" + i + ", " + String.valueOf(values) + ")");
            }
            if (this.result[i] != null) {
                return values.contains(this.result[i]);
            }
            if (values.isEmpty()) {
                return false;
            }
            if (values.size() == 1) {
                return this.setKnown(i, values.iterator().next());
            }
            ArrayList<Resource> oldAlternatives = this.alternatives[i];
            if (oldAlternatives == null) {
                this.alternatives[i] = new ArrayList<Resource>(values);
                return true;
            }
            oldAlternatives.retainAll(values);
            if (oldAlternatives.isEmpty()) {
                return false;
            }
            if (oldAlternatives.size() == 1) {
                return this.setKnown(i, oldAlternatives.get(0));
            }
            return true;
        }
    }
}

