/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.migration;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.DelayedWriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.migration.MigrationState;
import org.simantics.db.layer0.migration.MigrationStep;
import org.simantics.db.layer0.migration.MigrationUtils;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.WriteInterface;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingUtils;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.logging.TimeLogger;

public enum AttachCreationInformationStep implements MigrationStep
{
    INSTANCE;


    public static AttachCreationInformationStep get() {
        return INSTANCE;
    }

    public void applyTo(final IProgressMonitor monitor, Session session, MigrationState state) throws DatabaseException {
        final Resource indexRoot = MigrationUtils.getResource((IProgressMonitor)monitor, (Session)session, (MigrationState)state);
        if (indexRoot == null) {
            return;
        }
        session.sync((WriteInterface)new DelayedWriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                AttachCreationInformationStep.attach(monitor, graph, indexRoot);
            }
        });
    }

    private static void attach(IProgressMonitor monitor, WriteGraph graph, Resource indexRoot) throws DatabaseException {
        Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, (boolean)true);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        for (Resource model : graph.getObjects(indexRoot, L0.ConsistsOf)) {
            if (!graph.isInstanceOf(model, SIMU.Model)) continue;
            TimeLogger.log(AttachCreationInformationStep.class, (String)("attaching creation information to model " + NameUtils.getSafeName((ReadGraph)graph, (Resource)model)));
            ModelingUtils.attachCreationInformation(monitor, graph, model);
        }
    }
}

