/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.mapping;

import gnu.trove.map.hash.THashMap;
import java.util.Map;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.synchronization.CopyAdvisor;
import org.simantics.diagram.synchronization.ISynchronizationContext;
import org.simantics.diagram.synchronization.graph.GraphCopyAdvisor;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.mapping.ModelingSynchronizationHints;
import org.simantics.utils.datastructures.Pair;

public class MappedElementCopyAdvisor
extends GraphCopyAdvisor {
    protected final CopyAdvisor elementAdvisor;
    protected final CopyAdvisor componentAdvisor;

    public MappedElementCopyAdvisor(CopyAdvisor elementAdvisor, CopyAdvisor componentAdvisor) {
        this.elementAdvisor = elementAdvisor;
        this.componentAdvisor = componentAdvisor;
    }

    public CopyAdvisor.Evaluation canCopy(ISynchronizationContext context, WriteGraph graph, Resource source, Resource sourceContainer, Resource targetContainer) throws DatabaseException {
        if (CopyAdvisor.SUPPORTED.contains(this.elementAdvisor.canCopy(context, (Object)source, (Object)sourceContainer, (Object)targetContainer))) {
            Resource targetComposite;
            Resource sourceComposite;
            CopyAdvisor.Evaluation componentEval;
            ModelingResources MOD = (ModelingResources)context.get(ModelingSynchronizationHints.MODELING_RESOURCE);
            Resource component = graph.getPossibleObject(source, MOD.ElementToComponent);
            if (component != null && (componentEval = this.componentAdvisor.canCopy(context, (Object)component, (Object)(sourceComposite = sourceContainer != null ? graph.getPossibleObject(sourceContainer, MOD.DiagramToComposite) : null), (Object)(targetComposite = targetContainer != null ? graph.getPossibleObject(targetContainer, MOD.DiagramToComposite) : null))) != CopyAdvisor.Evaluation.SUPPORTED) {
                return componentEval;
            }
            Resource connection = graph.getPossibleObject(source, MOD.DiagramConnectionToConnection);
            if (connection != null) {
                Resource targetComposite2;
                Resource sourceComposite2 = graph.getPossibleObject(sourceContainer, MOD.DiagramToComposite);
                CopyAdvisor.Evaluation connectionEval = this.componentAdvisor.canCopy(context, (Object)connection, (Object)sourceComposite2, (Object)(targetComposite2 = graph.getPossibleObject(targetContainer, MOD.DiagramToComposite)));
                if (connectionEval != CopyAdvisor.Evaluation.SUPPORTED) {
                    return connectionEval;
                }
                Resource specialConnection = graph.getPossibleObject(source, MOD.DiagramConnectionToConnectionSpecial);
                if (specialConnection != null) {
                    connectionEval = this.componentAdvisor.canCopy(context, (Object)specialConnection, (Object)sourceComposite2, (Object)targetComposite2);
                }
                return connectionEval;
            }
            return CopyAdvisor.Evaluation.SUPPORTED;
        }
        return CopyAdvisor.Evaluation.NOT_SUPPORTED;
    }

    public Object copy(ISynchronizationContext context, WriteGraph graph, Resource source, Resource sourceContainer, Resource targetContainer) throws DatabaseException {
        return this.copy(context, graph, source, sourceContainer, targetContainer, (Map<Object, Object>)new THashMap());
    }

    public Object copy(ISynchronizationContext context, WriteGraph graph, Resource source, Resource sourceContainer, Resource targetContainer, Map<Object, Object> map) throws DatabaseException {
        Resource connection;
        ModelingResources MOD = (ModelingResources)context.get(ModelingSynchronizationHints.MODELING_RESOURCE);
        if (MOD == null) {
            throw new IllegalStateException("no ModelingSynchronizationHints.MODELING_RESOURCE hint");
        }
        Resource sourceComposite = sourceContainer != null ? graph.getPossibleObject(sourceContainer, MOD.DiagramToComposite) : null;
        Resource targetComposite = targetContainer != null ? graph.getPossibleObject(targetContainer, MOD.DiagramToComposite) : null;
        Resource elementCopy = (Resource)this.elementAdvisor.copy(context, (Object)source, (Object)sourceContainer, (Object)targetContainer, map);
        Resource component = graph.getPossibleObject(source, MOD.ElementToComponent);
        Resource componentCopy = null;
        if (component != null && (componentCopy = (Resource)this.componentAdvisor.copy(context, (Object)component, (Object)sourceComposite, (Object)targetComposite, map)) != null) {
            graph.claim(elementCopy, MOD.ElementToComponent, componentCopy);
        }
        if ((connection = graph.getPossibleObject(source, MOD.DiagramConnectionToConnection)) != null) {
            Resource specialConnectionCopy;
            Resource specialConnection;
            Resource connectionCopy = (Resource)this.componentAdvisor.copy(context, (Object)connection, (Object)sourceComposite, (Object)targetComposite, map);
            if (connectionCopy != null) {
                graph.claim(elementCopy, MOD.DiagramConnectionToConnection, connectionCopy);
            }
            if ((specialConnection = graph.getPossibleObject(source, MOD.DiagramConnectionToConnectionSpecial)) != null && (specialConnectionCopy = (Resource)this.componentAdvisor.copy(context, (Object)specialConnection, (Object)sourceComposite, (Object)targetComposite, map)) != null) {
                graph.claim(elementCopy, MOD.DiagramConnectionToConnectionSpecial, specialConnectionCopy);
            }
        }
        return elementCopy;
    }

    public Object cut(ISynchronizationContext context, WriteGraph graph, Resource source, Resource sourceContainer, Resource targetContainer) throws DatabaseException {
        ModelingResources MOD = (ModelingResources)context.get(ModelingSynchronizationHints.MODELING_RESOURCE);
        Resource sourceComposite = graph.getPossibleObject(sourceContainer, MOD.DiagramToComposite);
        Resource targetComposite = graph.getPossibleObject(targetContainer, MOD.DiagramToComposite);
        Resource component = graph.getPossibleObject(source, MOD.ElementToComponent);
        Resource connection = graph.getPossibleObject(source, MOD.DiagramConnectionToConnection);
        Object elementResult = this.elementAdvisor.cut(context, (Object)source, (Object)sourceContainer, (Object)targetContainer);
        Object componentResult = null;
        if (sourceComposite != null && targetComposite != null) {
            if (component != null) {
                componentResult = this.componentAdvisor.cut(context, (Object)component, (Object)sourceComposite, (Object)targetComposite);
            }
            if (connection != null) {
                componentResult = this.componentAdvisor.cut(context, (Object)connection, (Object)sourceComposite, (Object)targetComposite);
            }
        }
        if (elementResult == null && componentResult == null) {
            return null;
        }
        return Pair.make((Object)elementResult, componentResult);
    }

    public void onFinish(ISynchronizationContext context) {
        super.onFinish(context);
        this.elementAdvisor.onFinish(context);
        this.componentAdvisor.onFinish(context);
    }
}

