/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.mapping;

import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.FreshEscapedName;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.representation.Root;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;

public class ComponentAndElementPasteImportAdvisor
implements IImportAdvisor {
    private static boolean DEBUG = false;
    protected Resource element;
    protected Resource component;
    protected Root elementRoot;
    protected Root componentRoot;
    protected Resource composite;
    protected Resource diagram;
    protected Resource model;
    protected Map<String, String> nameMappings = new HashMap<String, String>();
    protected boolean includeComponent = true;
    protected boolean includeElement = true;

    public ComponentAndElementPasteImportAdvisor(ReadGraph graph, Resource composite) throws DatabaseException {
        this.composite = composite;
        this.diagram = graph.getPossibleObject(composite, ModelingResources.getInstance((ReadGraph)graph).CompositeToDiagram);
        this.includeElement = this.diagram != null;
        this.model = (Resource)graph.sync((ReadInterface)new PossibleModel(composite));
    }

    public ComponentAndElementPasteImportAdvisor(ReadGraph graph, Resource resource, boolean includeComponent, boolean includeElement) throws DatabaseException {
        if (!includeComponent && !includeElement) {
            throw new IllegalArgumentException();
        }
        this.includeComponent = includeComponent;
        this.includeElement = includeElement;
        if (includeComponent) {
            this.composite = resource;
            this.diagram = graph.getPossibleObject(this.composite, ModelingResources.getInstance((ReadGraph)graph).CompositeToDiagram);
            if (this.diagram == null) {
                this.includeElement = false;
            }
        } else {
            this.diagram = resource;
            this.composite = graph.getPossibleObject(this.diagram, ModelingResources.getInstance((ReadGraph)graph).DiagramToComposite);
        }
    }

    public Resource analyzeRoot(ReadGraph graph, Root root) throws DatabaseException {
        if ("%model".equals(root.name)) {
            return this.model;
        }
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        String type = root.type;
        Resource typeRes = graph.getResource(type);
        if (graph.isInheritedFrom(typeRes, DIA.Element)) {
            this.elementRoot = root;
            String newName = root.name;
            if (this.diagram != null) {
                newName = this.newName(graph, this.diagram, root.name);
            }
            this.nameMappings.put(root.name, newName);
        } else {
            this.componentRoot = root;
            String newName = this.newName(graph, this.composite, root.name);
            this.nameMappings.put(root.name, newName);
        }
        return null;
    }

    public String newName(ReadGraph graph, Resource library, String name) throws DatabaseException {
        return (String)graph.syncRequest((Read)new FreshEscapedName(library, Layer0.getInstance((ReadGraph)graph).ConsistsOf, name));
    }

    public Resource getComponent() {
        return this.component;
    }

    public Resource getElement() {
        return this.element;
    }

    public Resource createRoot(WriteOnlyGraph graph, Root root) throws DatabaseException {
        Layer0 l0 = (Layer0)graph.getService(Layer0.class);
        if (root == this.elementRoot) {
            this.element = graph.newResource();
            String name = root.name;
            String newName = this.nameMappings.get(name);
            graph.addLiteral(this.element, l0.HasName, l0.NameOf, l0.String, (Object)newName, (Binding)Bindings.STRING);
            if (DEBUG) {
                System.out.println("CaECopyAdvisor created element " + String.valueOf(this.element) + " " + newName);
            }
            return this.element;
        }
        if (root == this.componentRoot) {
            this.component = graph.newResource();
            String name = root.name;
            String newName = this.nameMappings.get(name);
            graph.addLiteral(this.component, l0.HasName, l0.NameOf, l0.String, (Object)newName, (Binding)Bindings.STRING);
            if (DEBUG) {
                System.out.println("CaECopyAdvisor created component " + String.valueOf(this.component) + " " + newName);
            }
            return this.component;
        }
        throw new DatabaseException("Unknown root " + String.valueOf(root));
    }

    public void attach(WriteGraph graph) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        if (this.includeComponent) {
            if (this.component != null) {
                graph.claim(this.composite, l0.ConsistsOf, l0.PartOf, this.component);
            }
        } else if (this.component != null) {
            graph.deny(this.component);
        }
        if (!this.includeElement) {
            if (this.element != null) {
                graph.deny(this.element);
            }
        } else {
            boolean created = false;
            if (this.element == null) {
                ModelingResources MR = ModelingResources.getInstance((ReadGraph)graph);
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
                Resource componentType = graph.getSingleType(this.component);
                Resource elementType = graph.getSingleObject(componentType, MR.ComponentTypeToSymbol);
                this.element = graph.newResource();
                String newName = this.newName((ReadGraph)graph, this.diagram, "element");
                graph.claimLiteral(this.element, l0.HasName, (Object)newName);
                graph.claim(this.element, l0.InstanceOf, elementType);
                graph.claim(this.component, MR.ComponentToElement, this.element);
                graph.claimLiteral(this.element, DIA.HasTransform, G2D.Transform, (Object)new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0});
                if (DEBUG) {
                    System.out.println("CaECopyAdvisor created deferred element " + String.valueOf(this.element) + " " + newName);
                }
                created = true;
            }
            graph.claim(this.diagram, l0.ConsistsOf, l0.PartOf, this.element);
            OrderedSetUtils.add((WriteGraph)graph, (Resource)this.diagram, (Resource)this.element);
            if (created) {
                this.createElement(graph, this.element);
            }
        }
    }

    public void createElement(WriteGraph graph, Resource element) throws DatabaseException {
    }
}

