/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.mapping;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.DefaultCopyHandler;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;

public class ComponentAndElementCopyHandler
extends DefaultCopyHandler {
    protected boolean includeComponent = true;
    protected boolean includeElement = true;

    public ComponentAndElementCopyHandler(Resource resource) {
        super(resource);
    }

    public ComponentAndElementCopyHandler(Resource resource, boolean includeComponent, boolean includeElement) {
        super(resource);
        if (!includeComponent && !includeElement) {
            throw new IllegalArgumentException();
        }
        this.includeComponent = includeComponent;
        this.includeElement = includeElement;
    }

    protected TransferableGraphConfiguration2 createConfiguration(ReadGraph graph, boolean cut) throws DatabaseException {
        ModelingResources MR = ModelingResources.getInstance((ReadGraph)graph);
        ArrayList<Resource> exclusions = new ArrayList<Resource>();
        ArrayList<NamedResource> roots = new ArrayList<NamedResource>();
        Resource component = null;
        Resource element = null;
        if (this.includeComponent) {
            component = this.getResource();
            element = graph.getPossibleObject(component, MR.ComponentToElement);
        } else {
            element = this.getResource();
            component = graph.getPossibleObject(element, MR.ElementToComponent);
        }
        if (component != null) {
            this.processComponent(graph, component, this.includeComponent, roots, exclusions);
        }
        if (element != null) {
            this.processElement(graph, element, this.includeElement, roots, exclusions);
        }
        return TransferableGraphConfiguration2.createWithNames((RequestProcessor)graph, roots, exclusions, (boolean)true, (boolean)false);
    }

    protected void processComponent(ReadGraph graph, Resource component, boolean includeComponent, ArrayList<NamedResource> roots, ArrayList<Resource> exclusions) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 SR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource resource = this.getResource();
        if (includeComponent) {
            String rootName = (String)graph.getRelatedValue(resource, L0.HasName, (Binding)Bindings.STRING);
            roots.add(new NamedResource(rootName, resource));
        } else {
            exclusions.add(component);
        }
        for (Resource connection : graph.getObjects(resource, SR.IsConnectedTo)) {
            exclusions.add(connection);
        }
    }

    protected void processElement(ReadGraph graph, Resource element, boolean includeElement, ArrayList<NamedResource> roots, ArrayList<Resource> exclusions) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        StructuralResource2 SR = StructuralResource2.getInstance((ReadGraph)graph);
        if (includeElement) {
            String name = (String)graph.getRelatedValue(element, L0.HasName, (Binding)Bindings.STRING);
            roots.add(new NamedResource(name, element));
        } else {
            exclusions.add(element);
        }
        Collection diagram_ = OrderedSetUtils.getOwnerLists((ReadGraph)graph, (Resource)element, (Resource)DIA.Diagram);
        for (Resource diagram : diagram_) {
            Resource inv = graph.getInverse(diagram);
            exclusions.add(diagram);
            exclusions.add(inv);
            Resource next = OrderedSetUtils.next((ReadGraph)graph, (Resource)diagram, (Resource)element);
            Resource previous = OrderedSetUtils.prev((ReadGraph)graph, (Resource)diagram, (Resource)element);
            if (next != null && !next.equals(element)) {
                exclusions.add(next);
            }
            if (previous == null || previous.equals(element) || previous.equals(next)) continue;
            exclusions.add(previous);
        }
        for (Resource connection : graph.getObjects(element, SR.IsConnectedTo)) {
            exclusions.add(connection);
        }
    }
}

