/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.adapters;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;

public class SCLChildRule
implements ChildRule {
    private Function1<Object, List<Resource>> getChildrenF;
    private Function1<Object, Boolean> hasChildrenF;

    public SCLChildRule(ReadGraph graph, Resource rule) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Variable ruleVariable = Variables.getVariable((ReadGraph)graph, (Resource)rule);
        this.getChildrenF = (Function1)ruleVariable.getPropertyValue(graph, MOD.SCLChildRule_getChildren);
        this.hasChildrenF = (Function1)ruleVariable.getPossiblePropertyValue(graph, MOD.SCLChildRule_hasChildren);
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class) || contentType.equals(Variable.class);
    }

    private Resource inputToResource(ReadGraph graph, Object parent) throws DatabaseException {
        if (parent instanceof Variable) {
            return ((Variable)parent).getRepresents(graph);
        }
        return (Resource)parent;
    }

    public Collection<Resource> getChildren(ReadGraph graph, Object parent) throws DatabaseException {
        if (this.getChildrenF == null) {
            return Collections.emptyList();
        }
        return this.apply(graph, this.getChildrenF, this.inputToResource(graph, parent));
    }

    public boolean hasChildren(ReadGraph graph, Object parent) throws DatabaseException {
        Resource r = this.inputToResource(graph, parent);
        if (this.hasChildrenF != null) {
            return this.apply(graph, this.hasChildrenF, r);
        }
        return !this.apply(graph, this.getChildrenF, r).isEmpty();
    }

    private <P, T> T apply(ReadGraph graph, Function1<P, T> f, P parameter) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.get((Object)"graph");
        try {
            sclContext.put((Object)"graph", (Object)graph);
            Object object = f.apply(parameter);
            return (T)object;
        }
        catch (Throwable t) {
            throw new DatabaseException(t);
        }
        finally {
            sclContext.put((Object)"graph", oldGraph);
        }
    }

    public Collection<?> getParents(ReadGraph graph, Object child) throws DatabaseException {
        return Collections.emptyList();
    }
}

