/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.adapters;

import org.simantics.browsing.ui.CheckedState;
import org.simantics.browsing.ui.model.check.CheckedStateRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableOrResource;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLCheckedStateRule
implements CheckedStateRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCLCheckedStateRule.class);
    private Resource rule;

    public SCLCheckedStateRule(ReadGraph graph, Resource rule) {
        this.rule = rule;
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class) || contentType.equals(Variable.class);
    }

    public CheckedState getCheckedState(ReadGraph graph, Object content) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Variable ruleVariable = Variables.getVariable((ReadGraph)graph, (Resource)this.rule);
        Function1 getLabels = (Function1)ruleVariable.getPossiblePropertyValue(graph, MOD.SCLCheckedStateRule_getState);
        if (getLabels == null) {
            LOGGER.warn("Didn't find value for subject={}, predicate={}.", (Object)this.rule, (Object)"http://www.simantics.org/Modeling-1.2/SCLCheckedStateRule/getState");
            return CheckedState.NOT_CHECKED;
        }
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.get((Object)"graph");
        try {
            sclContext.put((Object)"graph", (Object)graph);
            CheckedState checkedState = (CheckedState)getLabels.apply((Object)VariableOrResource.make((Object)content));
            return checkedState;
        }
        catch (Throwable t) {
            LOGGER.error("Calculating checked state failed.", t);
            throw new DatabaseException(t);
        }
        finally {
            sclContext.put((Object)"graph", oldGraph);
        }
    }
}

