/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.adapters;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.adapters.ElementRemover;

public class ReferenceElementRemover
extends ElementRemover {
    public ReferenceElementRemover(Resource referenceElement) {
        super(referenceElement);
    }

    @Override
    public void remove(WriteGraph graph) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource referencedComponent = graph.getPossibleObject(this.resource, MOD.HasParentComponent);
        Resource referenceRelation = graph.getPossibleObject(this.resource, MOD.HasReferenceRelation);
        if (referencedComponent != null && referenceRelation != null) {
            graph.deny(referencedComponent, referenceRelation);
        }
        super.remove(graph);
    }
}

