/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.scl.scriptEditor;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.scl.scriptEditor.SCLScriptEditorInput;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.simantics.utils.ui.workbench.WorkbenchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLScriptEditorAdapter
extends AbstractResourceEditorAdapter
implements EditorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCLScriptEditorAdapter.class);

    public SCLScriptEditorAdapter() {
        super("SCL Script Editor", null, 20);
    }

    private Resource toResource(Object input) {
        if (input instanceof IStructuredSelection) {
            input = ((IStructuredSelection)input).getFirstElement();
        }
        if (!(input instanceof Resource)) {
            if (input instanceof IAdaptable) {
                if ((input = ((IAdaptable)input).getAdapter(Resource.class)) == null) {
                    return null;
                }
            } else {
                return null;
            }
        }
        return (Resource)input;
    }

    public boolean canHandle(ReadGraph g, Object input) throws DatabaseException {
        Resource resource = this.toResource(input);
        return resource != null && g.isInstanceOf(resource, Layer0.getInstance((ReadGraph)g).SCLScript);
    }

    protected void openEditor(final Resource input) throws Exception {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page == null) {
            return;
        }
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                String uri = graph.getURI(input);
                PlatformUI.getWorkbench().getDisplay().asyncExec(SCLScriptEditorAdapter.openEditor(uri));
            }
        });
    }

    private static Runnable openEditor(String uri) {
        return () -> {
            try {
                WorkbenchUtils.openEditor((String)"org.simantics.modeling.ui.scl.scriptEditor", (IEditorInput)new SCLScriptEditorInput(uri));
            }
            catch (PartInitException e) {
                LOGGER.error("Could not initialize part", (Throwable)e);
            }
        };
    }
}

