/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor.handlers;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.modeling.actions.DisconnectFlag;
import org.simantics.utils.ui.ISelectionUtils;

public class DisconnectFlagHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        final Set resources = ISelectionUtils.filterSetSelection((Object)sel, Resource.class);
        if (resources.isEmpty()) {
            return null;
        }
        DatabaseJob job = new DatabaseJob("Disconnect Flags"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Simantics.getSession().syncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            graph.markUndoPoint();
                            DisconnectFlag.disconnectFlags((WriteGraph)graph, new ArrayList(resources));
                        }
                    });
                    return Status.OK_STATUS;
                }
                catch (DatabaseException e) {
                    return new Status(4, "org.simantics.modeling.ui", "Failed to disconnect flags.", (Throwable)e);
                }
            }
        };
        job.schedule();
        return null;
    }
}

