/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor.handlers;

import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.ReadInterface;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.modeling.ui.diagramEditor.handlers.CommandUtil;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.ui.workbench.action.ChooseActionRequest;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.action.IPriorityAction;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class DefaultElementDoubleClickHandler
extends AbstractCanvasParticipant {
    @DependencyReflection.Dependency
    Selection selection;

    public boolean accept(IElement element) {
        return true;
    }

    @EventHandlerReflection.EventHandler(priority=-10)
    public boolean handleDoubleClick(MouseEvent.MouseDoubleClickedEvent me) {
        Set sel = this.selection.getSelection(0);
        if (sel.size() == 1) {
            IElement e = (IElement)sel.iterator().next();
            if (!this.accept(e)) {
                return false;
            }
            final Object data = e.getHint(ElementHints.KEY_OBJECT);
            final Display display = PlatformUI.getWorkbench().getDisplay();
            if (display == null) {
                return false;
            }
            try {
                Boolean consumed = (Boolean)Simantics.getSession().sync((ReadInterface)new UniqueRead<Boolean>(){

                    public Boolean perform(ReadGraph graph) throws DatabaseException {
                        IPriorityAction[] actions = ChooseActionRequest.findActions((ReadGraph)graph, null, (Object)data, (String)"", (boolean)false, (boolean)false);
                        IPriorityAction priorityAction = (IPriorityAction)ChooseActionRequest.chooseAction(null, (IPriorityAction[])actions, null, (boolean)true);
                        if (priorityAction != null && priorityAction.getPriority() >= 10) {
                            display.asyncExec(DefaultElementDoubleClickHandler.actionAsRunnable((IAction)priorityAction));
                            return true;
                        }
                        if (data instanceof Resource) {
                            PlatformUI.getWorkbench().getDisplay().asyncExec(DefaultElementDoubleClickHandler.revealView("org.simantics.browsing.ui.graph.propertyView"));
                            return true;
                        }
                        return false;
                    }
                });
                return consumed;
            }
            catch (DatabaseException ex) {
                ErrorLogger.defaultLogError((Throwable)ex);
            }
        }
        return false;
    }

    public static Runnable revealView(final String viewIdPart) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    WorkbenchUtils.showView((String)viewIdPart, (int)2);
                }
                catch (PartInitException e) {
                    ExceptionUtils.logAndShowError((Throwable)e);
                }
            }
        };
    }

    public static Runnable revealAndShowView(final String viewIdPart) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    WorkbenchUtils.showView((String)viewIdPart, (int)2);
                    PlatformUI.getWorkbench().getDisplay().timerExec(500, DefaultElementDoubleClickHandler.showView(viewIdPart));
                }
                catch (PartInitException e) {
                    ExceptionUtils.logAndShowError((Throwable)e);
                }
            }
        };
    }

    public static Runnable showView(final String viewIdPart) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    CommandUtil.showView(viewIdPart);
                }
                catch (ExecutionException e) {
                    ExceptionUtils.logAndShowError((Throwable)e);
                }
            }
        };
    }

    public static Runnable actionAsRunnable(final IAction action) {
        return new Runnable(){

            @Override
            public void run() {
                action.run();
            }
        };
    }
}

