/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.simantics.Simantics;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.procedure.adapter.ProcedureAdapter;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.diagram.participant.pointertool.TerminalUtil;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class TerminalInformer
extends AbstractDiagramParticipant {
    public static final IHintContext.Key TERMINAL_INFO_DISABLED = new IHintContext.KeyOf(Boolean.class);
    @DependencyReflection.Dependency
    protected PointerInteractor pointerInteractor;
    Control control;
    transient Display display;
    IStatusLineManager statusLine;
    ImageDescriptor currentImage;
    @DependencyReflection.Dependency
    TransformUtil util;
    Point2D p1 = new Point2D.Double();
    Point2D p2 = new Point2D.Double();
    Rectangle2D rect = new Rectangle2D.Double();
    String viewingMessage;
    final TerminalNamingStrategy terminalNamingStrategy;
    private final AtomicBoolean requestPending = new AtomicBoolean(false);
    private final AtomicReference<TerminalUtil.TerminalInfo> currentTerminalRequest = new AtomicReference();

    public TerminalInformer(Control parentControl, ResourceManager resourceManager, IStatusLineManager statusLine, TerminalNamingStrategy terminalNamingStrategy) {
        this.control = parentControl;
        this.statusLine = statusLine;
        this.terminalNamingStrategy = terminalNamingStrategy;
    }

    public void removedFromContext(ICanvasContext ctx) {
        super.removedFromContext(ctx);
        final IStatusLineManager statusLine = this.statusLine;
        if (this.display != null && statusLine != null) {
            SWTUtils.asyncExec((Display)this.display, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (statusLine != null) {
                        statusLine.setMessage(null, null);
                        statusLine.setErrorMessage(null, null);
                    }
                    if (TerminalInformer.this.currentImage != null) {
                        JFaceResources.getResources().destroyImage(TerminalInformer.this.currentImage);
                    }
                }
            });
        }
    }

    public boolean infoDisabled() {
        return Boolean.TRUE.equals(this.getHint(TERMINAL_INFO_DISABLED));
    }

    private boolean isInfoEvent(Event e) {
        return this.terminalNamingStrategy != null ? this.terminalNamingStrategy.isInfoEnabled(e) : false;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleKeys(KeyEvent ke) {
        if (this.infoDisabled() || !this.isInfoEvent((Event)ke)) {
            this.setMessage(null);
            return false;
        }
        this.pickRect(this.rect);
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleMove(MouseEvent.MouseMovedEvent me) {
        double pickDist = this.pointerInteractor.getTerminalPickDistance();
        this.p1.setLocation(me.controlPosition.getX() - pickDist, me.controlPosition.getY() - pickDist);
        this.p2.setLocation(me.controlPosition.getX() + pickDist, me.controlPosition.getY() + pickDist);
        this.util.controlToCanvas(this.p1, this.p1);
        this.util.controlToCanvas(this.p2, this.p2);
        this.rect.setFrameFromDiagonal(this.p1, this.p2);
        if (this.infoDisabled() || !this.isInfoEvent((Event)me)) {
            this.setMessage(null);
            return false;
        }
        this.pickRect(this.rect);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMessage(TerminalUtil.TerminalInfo terminal, final Consumer<String> callback) {
        AtomicBoolean atomicBoolean = this.requestPending;
        synchronized (atomicBoolean) {
            this.currentTerminalRequest.set(terminal);
            if (this.requestPending.compareAndSet(false, true)) {
                Simantics.getSession().asyncRequest((Read)new ReadRequest(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(ReadGraph graph) throws DatabaseException {
                        TerminalUtil.TerminalInfo ti = null;
                        AtomicBoolean atomicBoolean = TerminalInformer.this.requestPending;
                        synchronized (atomicBoolean) {
                            ti = TerminalInformer.this.currentTerminalRequest.getAndSet(null);
                            TerminalInformer.this.requestPending.set(false);
                        }
                        String result = null;
                        if (ti != null) {
                            result = (String)graph.syncRequest((Read)new TerminalInfoMessage(ti, TerminalInformer.this.terminalNamingStrategy));
                        }
                        callback.accept(result);
                    }
                }, (Procedure)new ProcedureAdapter<Object>(){

                    public void exception(Throwable t) {
                        ErrorLogger.defaultLogError((Throwable)t);
                    }
                });
            }
        }
    }

    private void pickRect(Rectangle2D rect) {
        TerminalUtil.TerminalInfo terminal = TerminalUtil.pickTerminal((ICanvasContext)this.getContext(), (IDiagram)this.diagram, (Shape)rect);
        if (terminal != null) {
            this.createMessage(terminal, message -> this.setMessage(null, (String)message));
        } else {
            this.setMessage(null);
        }
    }

    private void setMessage(String message) {
        this.setMessage(null, message);
    }

    private void setMessage(final ImageDescriptor imageDescriptor, String _message) {
        if (_message != null && _message.isEmpty()) {
            _message = null;
        }
        final String message = _message;
        if (this.viewingMessage == null && message == null) {
            return;
        }
        if (ObjectUtils.objectEquals((Object)this.viewingMessage, (Object)message)) {
            return;
        }
        this.viewingMessage = message;
        SWTUtils.asyncExec((Widget)this.control, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (TerminalInformer.this.control.isDisposed()) {
                    return;
                }
                TerminalInformer.this.display = TerminalInformer.this.control.getDisplay();
                Image img = null;
                ResourceManager rm = JFaceResources.getResources();
                if (imageDescriptor != null) {
                    if (imageDescriptor.equals(TerminalInformer.this.currentImage)) {
                        img = (Image)rm.find((DeviceResourceDescriptor)imageDescriptor);
                    } else {
                        img = rm.createImage(imageDescriptor);
                        TerminalInformer.this.currentImage = imageDescriptor;
                    }
                } else if (TerminalInformer.this.currentImage != null) {
                    rm.destroyImage(TerminalInformer.this.currentImage);
                    TerminalInformer.this.currentImage = null;
                }
                IStatusLineManager statusLine = TerminalInformer.this.getStatusLine();
                if (statusLine != null) {
                    statusLine.setMessage(img, message);
                    statusLine.setErrorMessage(null);
                }
            }
        });
    }

    protected IStatusLineManager getStatusLine() {
        IWorkbenchPart activePart = WorkbenchUtils.getActiveWorkbenchPart();
        if (activePart != null) {
            this.statusLine = this.statusLine = WorkbenchUtils.getStatusLine((IWorkbenchPart)activePart);
            return this.statusLine;
        }
        return null;
    }

    static class TerminalInfoMessage
    extends BinaryRead<TerminalUtil.TerminalInfo, TerminalNamingStrategy, String> {
        public TerminalInfoMessage(TerminalUtil.TerminalInfo info, TerminalNamingStrategy strategy) {
            super((Object)info, (Object)strategy);
        }

        public String perform(ReadGraph graph) throws DatabaseException {
            return ((TerminalNamingStrategy)this.parameter2).getName(graph, (TerminalUtil.TerminalInfo)this.parameter);
        }
    }

    public static interface TerminalNamingStrategy {
        public String getName(ReadGraph var1, TerminalUtil.TerminalInfo var2) throws DatabaseException;

        /*
         * WARNING - void declaration
         */
        default public boolean isInfoEnabled(Event e) {
            Event event = e;
            if (event instanceof MouseEvent.MouseMovedEvent) {
                void me;
                MouseEvent.MouseMovedEvent mouseMovedEvent = (MouseEvent.MouseMovedEvent)event;
                MouseEvent.MouseMovedEvent cfr_ignored_0 = (MouseEvent.MouseMovedEvent)event;
                return (me.stateMask & 0x80) != 0;
            }
            Event event2 = e;
            if (event2 instanceof KeyEvent) {
                void ke;
                KeyEvent keyEvent = (KeyEvent)event2;
                KeyEvent cfr_ignored_1 = (KeyEvent)event2;
                return ke.keyCode == 17 && ke instanceof KeyEvent.KeyPressedEvent;
            }
            return false;
        }
    }
}

