/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.EnumSet;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.LifeCycle;
import org.simantics.g2d.element.handler.Move;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.Rotate;
import org.simantics.g2d.element.handler.Scale;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.StaticSymbol;
import org.simantics.g2d.element.handler.TextEditor;
import org.simantics.g2d.element.handler.Transform;
import org.simantics.g2d.element.handler.impl.BorderColorImpl;
import org.simantics.g2d.element.handler.impl.SimpleElementLayers;
import org.simantics.g2d.element.handler.impl.StaticSymbolImpl;
import org.simantics.g2d.element.handler.impl.TextColorImpl;
import org.simantics.g2d.element.handler.impl.TextEditorImpl;
import org.simantics.g2d.element.handler.impl.TextFontImpl;
import org.simantics.g2d.element.handler.impl.TextImpl;
import org.simantics.g2d.elementclass.MonitorHandler;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.ProviderUtils;
import org.simantics.g2d.image.impl.AbstractImage;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.swing.SliderNode;
import org.simantics.utils.datastructures.cache.IFactory;
import org.simantics.utils.datastructures.cache.IProvider;
import org.simantics.utils.datastructures.cache.ProvisionException;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.strings.format.MetricsFormat;
import org.simantics.utils.strings.format.MetricsFormatList;

public class SliderClass {
    public static final IHintContext.Key KEY_SLIDER_RESOURCE_PATH = new IHintContext.KeyOf(Collection.class, "SLIDER_RESOURCE_PATH");
    public static final IHintContext.Key KEY_SLIDER_COMPONENT = new IHintContext.KeyOf(Object.class, "SLIDER_COMPONENT");
    public static final IHintContext.Key KEY_SLIDER_SUFFIX = new IHintContext.KeyOf(String.class, "SLIDER_SUFFIX");
    public static final IHintContext.Key KEY_SLIDER_RANGE = new IHintContext.KeyOf(Range.class, "SLIDER_SUBSTITUTIONS");
    public static final IHintContext.Key KEY_SLIDER_GC = new IHintContext.KeyOf(Graphics2D.class, "SLIDER_GC");
    public static final IHintContext.Key KEY_SLIDER_VALUE = new IHintContext.KeyOf(Double.class, "SLIDER_VALUE");
    public static final IHintContext.Key KEY_TOOLTIP_TEXT = new IHintContext.KeyOf(String.class, "TOOLTIP_TEXT");
    public static final IHintContext.Key KEY_NUMBER_FORMAT = new IHintContext.KeyOf(MetricsFormat.class, "NUMBER_FORMAT");
    public static final IHintContext.Key KEY_DIRECTION = new IHintContext.KeyOf(Double.class, "SLIDER_DIRECTION");
    public static final IHintContext.Key KEY_SG_NODE = new SceneGraphNodeKey(Node.class, "SLIDER_SG_NODE");
    public static final MetricsFormat DEFAULT_NUMBER_FORMAT = MetricsFormatList.METRICS_DECIMAL;
    static final IProvider<Image> SLIDER_IMAGE = ProviderUtils.reference((IProvider)ProviderUtils.cache((IFactory)ProviderUtils.rasterize((IProvider)new SliderImageFactory(0.5, 0.5))));
    static final StaticSymbol SLIDER_SYMBOL = new StaticSymbolImpl((Image)SLIDER_IMAGE.get());
    public static final ElementClass SLIDER_CLASS = ElementClass.compile((ElementHandler[])new ElementHandler[]{SliderHandlerImpl.INSTANCE, Transformer.INSTANCE, BorderColorImpl.BLACK, SliderSGNode.INSTANCE, TextImpl.INSTANCE, TextEditorImpl.INSTANCE, TextFontImpl.DEFAULT, TextColorImpl.BLACK, SimpleElementLayers.INSTANCE, SLIDER_SYMBOL});

    static MetricsFormat getNumberFormat(IElement e) {
        return (MetricsFormat)ElementUtils.getHintOrDefault((IHintContext)e, (IHintContext.Key)KEY_NUMBER_FORMAT, (Object)DEFAULT_NUMBER_FORMAT);
    }

    static void setNumberFormat(IElement e, MetricsFormat f) {
        ElementUtils.setOrRemoveHint((IHintContext)e, (IHintContext.Key)KEY_NUMBER_FORMAT, (Object)f);
    }

    public static void update(IElement e) {
        SliderSGNode node = (SliderSGNode)e.getElementClass().getAtMostOneItemOfClass(SliderSGNode.class);
        node.update(e);
    }

    public static void cleanup(IElement e) {
        SliderSGNode node = (SliderSGNode)e.getElementClass().getAtMostOneItemOfClass(SliderSGNode.class);
        node.cleanup(e);
    }

    static double getOrientationDelta(IElement e, AffineTransform tr) {
        Double angle = (Double)e.getHint(KEY_DIRECTION);
        if (angle == null || Double.isNaN(angle)) {
            return Double.NaN;
        }
        double angrad = Math.toRadians(angle);
        Vector2D forcedAxis = new Vector2D(Math.cos(angrad), Math.sin(angrad));
        Vector2D x = new Vector2D(tr.getScaleX(), tr.getShearX()).normalize();
        double cosa = forcedAxis.dotProduct((Vector)x);
        double delta = Math.acos(cosa);
        return delta;
    }

    public static ElementClass create(IElement parentElement, Range<Double> range, Double value, Object component, String suffix, double staticScaleX, double staticScaleY, ElementHandler ... extraHandlers) {
        IFactory staticSliderSymbolProvider = ProviderUtils.reference((IProvider)ProviderUtils.cache((IFactory)ProviderUtils.rasterize((IProvider)new SliderImageFactory(staticScaleX, staticScaleY))));
        StaticSymbolImpl staticSliderSymbol = new StaticSymbolImpl((Image)staticSliderSymbolProvider.get());
        return ElementClass.compile((ElementHandler[])new ElementHandler[]{new Initializer(parentElement, range, value, component, suffix, parentElement == null), SliderHandlerImpl.INSTANCE, Transformer.INSTANCE, BorderColorImpl.BLACK, SliderSGNode.INSTANCE, TextImpl.INSTANCE, TextEditorImpl.INSTANCE, TextFontImpl.DEFAULT, TextColorImpl.BLACK, SimpleElementLayers.INSTANCE, staticSliderSymbol}).newClassWith(extraHandlers);
    }

    static class Initializer
    implements LifeCycle {
        private static final long serialVersionUID = 4404942036933073584L;
        IElement parentElement;
        Range<Double> range;
        Object component;
        String suffix;
        Double value;
        Boolean hack;

        Initializer(IElement parentElement, Range<Double> range, Double value, Object component, String suffix, Boolean hack) {
            this.parentElement = parentElement;
            this.range = range;
            this.component = component;
            this.suffix = suffix;
            this.value = value;
            this.hack = hack;
        }

        public void onElementActivated(IDiagram d, IElement e) {
            if (!this.hack.booleanValue()) {
                this.hack = true;
                Point2D parentPos = ElementUtils.getPos((IElement)this.parentElement);
                Point2D thisPos = ElementUtils.getPos((IElement)e);
                Move move = (Move)e.getElementClass().getSingleItem(Move.class);
                move.moveTo(e, thisPos.getX() - parentPos.getX(), thisPos.getY() - parentPos.getY());
            }
        }

        public void onElementCreated(IElement e) {
            if (this.parentElement != null) {
                e.setHint(ElementHints.KEY_PARENT_ELEMENT, (Object)this.parentElement);
            }
            if (this.range != null) {
                e.setHint(KEY_SLIDER_RANGE, this.range);
            }
            if (this.component != null) {
                e.setHint(KEY_SLIDER_COMPONENT, this.component);
            }
            if (this.suffix != null) {
                e.setHint(KEY_SLIDER_SUFFIX, (Object)this.suffix);
            }
            if (this.value != null) {
                e.setHint(KEY_SLIDER_VALUE, (Object)this.value);
            }
            e.setHint(KEY_DIRECTION, (Object)0.0);
            e.setHint(KEY_NUMBER_FORMAT, (Object)DEFAULT_NUMBER_FORMAT);
        }

        public void onElementDeactivated(IDiagram d, IElement e) {
        }

        public void onElementDestroyed(IElement e) {
        }
    }

    public static class Range<T> {
        T min;
        T max;

        public Range(T min, T max) {
            this.min = min;
            this.max = max;
        }

        public T getMin() {
            return this.min;
        }

        public T getMax() {
            return this.max;
        }
    }

    public static class SliderHandlerImpl
    implements MonitorHandler {
        private static final long serialVersionUID = -4258875745321808416L;
        public static final MonitorHandler INSTANCE = new SliderHandlerImpl();
    }

    static class SliderImageFactory
    implements IFactory<Image> {
        private double staticScaleX = 1.0;
        private double staticScaleY = 1.0;

        public SliderImageFactory(double staticScaleX, double staticScaleY) {
            this.staticScaleX = staticScaleX;
            this.staticScaleY = staticScaleY;
        }

        public Image get() throws ProvisionException {
            return new AbstractImage(){
                Shape path;
                {
                    this.path = new Rectangle2D.Double(0.0, 0.0, 50.0 * sliderImageFactory.staticScaleX, 22.0 * sliderImageFactory.staticScaleY);
                }

                public Rectangle2D getBounds() {
                    return this.path.getBounds2D();
                }

                public EnumSet<Image.Feature> getFeatures() {
                    return EnumSet.of(Image.Feature.Vector);
                }

                public Shape getOutline() {
                    return this.path;
                }

                public Node init(G2DParentNode parent) {
                    SliderNode node = (SliderNode)parent.getOrCreateNode("" + ((Object)((Object)this)).hashCode(), SliderNode.class);
                    node.setValue(Integer.valueOf(0));
                    node.setBounds((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, 50.0, 22.0));
                    node.setTransform(AffineTransform.getScaleInstance(staticScaleX, staticScaleY));
                    return node;
                }
            };
        }
    }

    public static class SliderSGNode
    implements SceneGraph,
    InternalSize,
    Outline {
        private static final long serialVersionUID = -106278359626957687L;
        public static final SliderSGNode INSTANCE = new SliderSGNode();

        public void init(final IElement e, G2DParentNode parent) {
            SliderNode node = (SliderNode)e.getHint(KEY_SG_NODE);
            if (node == null || node.getBounds() == null || node.getParent() != parent) {
                node = (SliderNode)parent.addNode(ElementUtils.generateNodeId((IElement)e), SliderNode.class);
                e.setHint(KEY_SG_NODE, (Object)node);
                node.setActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        TextEditor.Modifier modifier;
                        TextEditor editor = (TextEditor)e.getElementClass().getAtMostOneItemOfClass(TextEditor.class);
                        if (editor != null && (modifier = editor.getModifier(e)) != null) {
                            modifier.modify(e, event.getActionCommand());
                        }
                    }
                });
                node.setBounds((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, 32.0, 100.0));
                Range range = (Range)e.getHint(KEY_SLIDER_RANGE);
                Double value = (Double)e.getHint(KEY_SLIDER_VALUE);
                node.setMinimum(Integer.valueOf((int)Math.round((Double)range.getMin())));
                node.setMaximum(Integer.valueOf((int)Math.round((Double)range.getMax())));
                node.setValue(Integer.valueOf((int)Math.round(value)));
                node.setMajorTickSpacing(Integer.valueOf(10));
                node.setMinorTickSpacing(Integer.valueOf(5));
                node.setPaintLabels(Boolean.valueOf(true));
                node.setOrientation(Integer.valueOf(1));
            }
            this.update(e);
        }

        public void update(IElement e) {
            Double value = (Double)e.getHint(KEY_SLIDER_VALUE);
            SliderNode node = (SliderNode)e.getHint(KEY_SG_NODE);
            if (node != null && value != null) {
                node.setValue(Integer.valueOf((int)Math.round(value)));
            }
        }

        public void cleanup(IElement e) {
            SliderNode node = (SliderNode)e.removeHint(KEY_SG_NODE);
            if (node != null) {
                node.remove();
            }
        }

        public Rectangle2D getBounds(IElement e, Rectangle2D size) {
            Rectangle2D shape = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            SliderNode node = (SliderNode)e.getHint(KEY_SG_NODE);
            if (node != null && node.getBounds() != null) {
                shape = node.getBounds().getBounds2D();
            }
            if (size != null) {
                size.setRect(shape);
            }
            return shape;
        }

        public Shape getElementShape(IElement e) {
            Rectangle2D shape = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            SliderNode node = (SliderNode)e.getHint(KEY_SG_NODE);
            if (node != null && node.getBounds() != null) {
                shape = node.getBounds();
            }
            return shape;
        }
    }

    public static class Transformer
    implements Transform,
    Move,
    Rotate,
    Scale {
        private static final long serialVersionUID = -3704887325602085677L;
        public static final Transformer INSTANCE = new Transformer(null);
        Double aspectRatio;

        public Transformer() {
            this(null);
        }

        public Transformer(Double aspectRatio) {
            this.aspectRatio = aspectRatio;
        }

        public Double getFixedAspectRatio(IElement e) {
            return this.aspectRatio;
        }

        public Point2D getScale(IElement e) {
            AffineTransform at = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
            return Transformer._getScale(at);
        }

        public void setScale(IElement e, Point2D newScale) {
            Point2D oldScale = this.getScale(e);
            double sx = newScale.getX() / oldScale.getX();
            double sy = newScale.getY() / oldScale.getY();
            AffineTransform at = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
            at = new AffineTransform(at);
            at.scale(sx, sy);
            e.setHint(ElementHints.KEY_TRANSFORM, (Object)at);
        }

        public Point2D getMaximumScale(IElement e) {
            return null;
        }

        public Point2D getMinimumScale(IElement e) {
            return null;
        }

        private static Point2D _getScale(AffineTransform at) {
            double m00 = at.getScaleX();
            double m11 = at.getScaleY();
            double m10 = at.getShearY();
            double m01 = at.getShearX();
            double sx = Math.sqrt(m00 * m00 + m10 * m10);
            double sy = Math.sqrt(m01 * m01 + m11 * m11);
            return new Point2D.Double(sx, sy);
        }

        public void rotate(IElement e, double theta, Point2D origin) {
            if (Double.isNaN(theta)) {
                return;
            }
            theta = Math.toDegrees(theta);
            Double angle = (Double)e.getHint(KEY_DIRECTION);
            double newAngle = angle != null ? angle + theta : theta;
            newAngle = Math.IEEEremainder(newAngle, 360.0);
            e.setHint(KEY_DIRECTION, (Object)newAngle);
        }

        public double getAngle(IElement e) {
            Double angle = (Double)e.getHint(KEY_DIRECTION);
            return angle != null ? Math.toRadians(angle) : 0.0;
        }

        public Point2D getPosition(IElement e) {
            AffineTransform at = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
            Point2D.Double p = new Point2D.Double(at.getTranslateX(), at.getTranslateY());
            return p;
        }

        public void moveTo(IElement e, double x, double y) {
            AffineTransform origAt = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
            double oldX = origAt.getTranslateX();
            double oldY = origAt.getTranslateY();
            AffineTransform move = AffineTransform.getTranslateInstance(x - oldX, y - oldY);
            AffineTransform at2 = new AffineTransform(origAt);
            at2.preConcatenate(move);
            e.setHint(ElementHints.KEY_TRANSFORM, (Object)at2);
        }

        public AffineTransform getTransform(IElement e) {
            AffineTransform at = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
            IElement parentElement = (IElement)e.getHint(ElementHints.KEY_PARENT_ELEMENT);
            if (parentElement == null) {
                return at;
            }
            Transform parentTransform = (Transform)parentElement.getElementClass().getSingleItem(Transform.class);
            assert (parentTransform != null);
            AffineTransform result = (AffineTransform)at.clone();
            result.preConcatenate(parentTransform.getTransform(parentElement));
            return result;
        }

        public void setTransform(IElement e, AffineTransform at) {
            e.setHint(ElementHints.KEY_TRANSFORM, at.clone());
        }
    }
}

