package org.simantics.modeling.ui.typicals;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.modeling.typicals.SyncTypicalTemplatesToInstances;
import org.simantics.modeling.ui.documents.OpenPlainTextDocumentAdapter;
import org.simantics.modeling.ui.property.TypicalPropertyTester;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.utils.ui.ErrorLogger;

/**
 * @author Tuukka Lehtonen
 */
public class SyncCurrentTypicalTemplateToInstances extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell(event);
        IEditorPart activeEditor = HandlerUtil.getActiveEditorChecked(event);
        IResourceEditorInput input = (IResourceEditorInput) activeEditor.getEditorInput();
        Session session = Simantics.getSession();

//        if (!MessageDialog
//                .openConfirm(shell,
//                        "Synchronize Typical Template With Instances",
//                        "Are you sure you want to synchronize all instances of this typical template with the template?"))
//            return null;

        try {
            if (!TypicalPropertyTester.isTypicalMasterEditor(session, input.getResource())) {
                MessageDialog.openInformation(shell, "Not Synchronizing", "Currently active editor is not a typical diagram template editor.");
                return null;
            }

            RuleChooserDialog.RuleResult result = RuleChooserDialog.choose(shell, "Synchronizing typical template to all its instances in the currently active model.", new Resource[] { input.getResource() });
            if(result == null) return null;

            session.markUndoPoint();
            SyncTypicalTemplatesToInstances req = new SyncTypicalTemplatesToInstances(result.selectedRules, input.getResource()).logging(result.logging); 
            session.syncRequest(req);
            if (result.logging) {
                for(Resource log : req.logs)
                    new OpenPlainTextDocumentAdapter().openEditor(log);
            }
        } catch (Exception e) {
            ErrorLogger.defaultLogError(e);
        }
        return null;
    }

}
