/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.scl.scriptEditor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.ui.IWorkbenchPart;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.primitiverequest.RelatedValue;
import org.simantics.db.common.uri.ResourceToPossibleURI;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.scl.SCLScripts;
import org.simantics.modeling.ui.Activator;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

/**
 * @author Tuukka Lehtonen
 * @since 1.31.0
 */
public class RunSCLScriptActionFactory implements ActionFactory {

	@Override
	public Runnable create(Object target) {
		if(!(target instanceof Resource))
			return null;
		return () -> runScript((Resource) target);
	}

	public static void runScript(Resource resource) {
		try {
			Session s = Simantics.getSession();
			Layer0 L0 = Layer0.getInstance(s);
			String error = SCLScripts.canRunScript(s, resource);
			IWorkbenchPart part = WorkbenchUtils.getActiveWorkbenchPart();
			IStatusLineManager status = part != null ? WorkbenchUtils.getStatusLine(part) : null;
			if (error == null) {
				String scriptName = s.syncRequest(new RelatedValue<String>(resource, L0.HasName, Bindings.STRING));
				String text = s.syncRequest(new RelatedValue<String>(resource, L0.SCLScript_definition, Bindings.STRING));
				String scriptUrl = s.syncRequest(new ResourceToPossibleURI(resource));
				Pair<CommandSession, SCLReportingHandler> p = SCLScripts.getOrCreateConsoleCommandSession();
				p.first.setRelativeResolutionModuleName(scriptUrl);
				SCLScripts.runScriptWithProgress(scriptName, text, p.first, p.second);
				status.setErrorMessage(null);
			} else {
				if (status != null)
					status.setErrorMessage(error);
			}
		} catch (DatabaseException e) {
			Activator.getDefault().getLog().log(new Status(IStatus.ERROR, Activator.PLUGIN_ID, "Failed to run SCL script.", e));
			return;
		}
	}

}
