/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.model;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.Activator;
import org.simantics.operation.Layer0X;

@Deprecated
public class RelationViews extends Node {

    public RelationViews(Resource resource) {
        super(resource);
    }

    @Override
    public String getLabel(ReadGraph g) {
        return "Relation views";
    }

    @Override
    public Collection<?> getChildren(ReadGraph g) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance(g);
        Layer0X L0X = Layer0X.getInstance(g);
        Collection<Resource> ret = new ArrayList<Resource>();
        for (Resource r : g.syncRequest(new ObjectsWithType(resource, l0.ConsistsOf, L0X.RelationView))) {
            ret.add(r);
        }
        return ret;
    }

    @Override
    public ImageDescriptor getImage(ReadGraph g) {
        return Activator.SPREADSHEETS_ICON;
    }

    @Override
    public Object getAdapter(Class adapter) {
        // deny adaptability, prevent showing of properties this way.
        return null;
    }

}