/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.browsing.ui.common.node.IRefreshable;

public class RefreshNodeHandler extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection(event);
        if (!(selection instanceof IStructuredSelection))
            return null;

        IStructuredSelection iss = (IStructuredSelection) selection;
        for (Object o : iss.toArray()) {
            IRefreshable ref = null;
            if (o instanceof IRefreshable) {
                ref = (IRefreshable) o;
            } else if (o instanceof IAdaptable) {
                ref = (IRefreshable) ((IAdaptable) o).getAdapter(IRefreshable.class);
            }

            if (ref != null)
                ref.refresh();
        }
        return null;
    }

}
