package org.simantics.modeling.ui.diagram.monitor;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.datastructures.Pair;

public class AvailableFontFactory extends ReadFactoryImpl<Object, List<Pair<String, Object>>> {

	@Override
	public List<Pair<String, Object>> perform(ReadGraph graph, Object input) throws DatabaseException {
		
		GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
		String[] fonts = ge.getAvailableFontFamilyNames();
		Arrays.sort(fonts);
        ArrayList<Pair<String, Object>> result = new ArrayList<Pair<String, Object>>();
		for(String font : fonts) {
			result.add(Pair.make(font, (Object)font));
		}
        return result;
		
	}
	
}
