/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.actions;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.validation.ValidateMapping;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural.ui.modelBrowser.nodes.CompositeNode;

public class ValidateMappingHandler extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();

        if (!selection.isEmpty() && selection instanceof StructuredSelection) {
            final Set<Resource> compositesToTest = new HashSet<Resource>(); 

            final List<?> elements = ((StructuredSelection) selection).toList();
            for (Object element : elements) {
                if (element instanceof IAdaptable) {
                    Resource node = (Resource) ((IAdaptable) element).getAdapter(Resource.class);
                    if (node != null) {
                        compositesToTest.add(node);
                    }
                }
            }

            Simantics.getSession().asyncRequest(new ReadRequest() {
                @Override
                public void run(ReadGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance(graph); 
                    StructuralResource2 STR = StructuralResource2.getInstance(graph);

                    // Try to test all child composites also.
                    Deque<Resource> toBeChecked = new ArrayDeque<Resource>(compositesToTest);
                    while (!toBeChecked.isEmpty()) {
                        Resource check = toBeChecked.poll();

                        for (Resource child : graph.syncRequest(new ObjectsWithType(check, L0.ConsistsOf, STR.Composite))) {
                            if (compositesToTest.add(child))
                                toBeChecked.offer(child);
                        }
                    }

                    for (Resource composite : compositesToTest)
                        graph.syncRequest(new ValidateMapping(composite));
                }
            });
        }
        return null;
    }

}
