package org.simantics.modeling.ui.actions;

import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ModelingResources;

/**
 * @author Tuukka Lehtonen
 */
public class NewLocalLibrary extends NewLibrary {

    protected Resource createLocalLibrary(WriteGraph graph, Resource parent)
            throws DatabaseException {
        Resource lib = super.createLibrary(graph, parent);
        ModelingResources MOD = ModelingResources.getInstance(graph);
        graph.claim(lib, MOD.IsLocalLibraryOf, parent);
        
        return lib;
    }
    
    public Resource newLibrary(final Resource model) throws DatabaseException {
    	Resource library = Simantics.getSession().syncRequest(new WriteResultRequest<Resource>() {

			@Override
			public Resource perform(WriteGraph graph) throws DatabaseException {
				Resource library = createLocalLibrary(graph, model);
				return library;
			}
		});
    	return library;
    }

}
