package org.simantics.modeling.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.ISelectionUtils;

/**
 * @author Tuukka Lehtonen
 */
public abstract class FlagOperationHandler extends AbstractHandler {

    protected abstract void perform(IProgressMonitor monitor, WriteGraph graph, List<Resource> flags,
            ICanvasContext canvasContext) throws DatabaseException;

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        //System.out.println("mergeFlags");
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService()
            .getSelection();

        IWorkbenchPart part = HandlerUtil.getActivePartChecked(event);
        final ICanvasContext canvasContext = (ICanvasContext) part.getAdapter(ICanvasContext.class);

        if (selection instanceof IStructuredSelection) {
            final List<Resource> flags = ISelectionUtils.getPossibleKeys(selection, SelectionHints.KEY_MAIN, Resource.class);
            try {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                new ProgressMonitorDialog(shell).run(true, false, new IRunnableWithProgress() {
                    @Override
                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        runWithProgress(monitor, flags, canvasContext);
                    }
                });
            } catch (InvocationTargetException e) {
                ExceptionUtils.logAndShowError(e.getTargetException());
            } catch (InterruptedException e) {
            }
        }
        return null;
    }

    protected void runWithProgress(final IProgressMonitor monitor, final List<Resource> flags, final ICanvasContext canvasContext) throws InvocationTargetException {
        try {
            Simantics.getSession().sync(new WriteRequest() {
                @Override
                public void perform(WriteGraph graph) throws DatabaseException {
                    graph.markUndoPoint();
                    FlagOperationHandler.this.perform(monitor, graph, flags, canvasContext);
                }
            });
        } catch (CancelTransactionException e) {
            // OK.
        } catch (DatabaseException e) {
            throw new InvocationTargetException(e);
        } finally {
            monitor.done();
        }
    }

}