/*******************************************************************************
 * Copyright (c) 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.adapters;

import org.simantics.db.Metadata;
import org.simantics.db.Session;
import org.simantics.db.layer0.genericrelation.DependencyChanges.ComponentAddition;
import org.simantics.modeling.utils.OntologicalRequirementTracker;

/**
 * A tagging metadata entry that is used for marking a graph transaction as one
 * after which {@link OntologicalRequirementTracker} should ensure that it adds
 * L0.identifiers for all {@link ComponentAddition}s that require identifiers.
 * 
 * @author Tuukka Lehtonen
 * @see OntologicalRequirementTracker
 * @see ComponentAddition
 */
public class AddMissingIdentifiers implements Metadata {

	@Override
	public byte[] serialise(Session session) {
		return new byte[0];
	}

	public static AddMissingIdentifiers deserialise(Session session, byte[] input) {
		return new AddMissingIdentifiers();
	}

}
