/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.actions;

import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.PossibleRelatedValue2;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.modeling.ModelingResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Help implements ActionFactory {

	private static final Logger LOGGER = LoggerFactory.getLogger(Help.class);

	@Override
	public Runnable create(Object target) {
		if (!(target instanceof Resource))
			return null;

		final Resource resource = (Resource) target;

		return () -> {
			try {
				ModelingResources MOD = ModelingResources.getInstance(Simantics.getSession());
				String id = Simantics.sync(new PossibleRelatedValue2<String>(resource, MOD.contextualHelpId, Bindings.STRING));
				if (id == null) {
					PlatformUI.getWorkbench().getHelpSystem().displayDynamicHelp();
					return;
				}
				PlatformUI.getWorkbench().getHelpSystem().displayHelp(id);
			} catch (DatabaseException e) {
				LOGGER.error("Failed to display help for resource {}", resource, e);
			}
		}; 
	}

}
