package org.simantics.modeling.utils;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ModelingResources;

/**
 * Utilities for dealing with diagram monitors.
 * 
 * @author Tuukka Lehtonen
 */
public final class Monitors {

    public static Resource getMonitoredComponent(ReadGraph graph, Resource monitor) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance(graph);
        Resource component = graph.getPossibleObject(monitor, DIA.HasMonitorComponent);
        return component;
    }

    public static Resource getMonitoredElement(ReadGraph graph, Resource monitor) throws DatabaseException {
        Resource component = getMonitoredComponent(graph, monitor);
        if (component == null)
            return null;
        ModelingResources MOD = ModelingResources.getInstance(graph);
        Resource element = graph.getPossibleObject(component, MOD.ComponentToElement);
        return element;
    }

}
