/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.typicals.rules;

import java.util.Collection;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.typicals.ITypicalSynchronizationRule;
import org.simantics.modeling.typicals.TypicalInfo;

/**
 * Synchronizes L0.InstanceOf relations from template to instance.
 * 
 * @author Tuukka Lehtonen
 */
public enum InstanceOfRule implements ITypicalSynchronizationRule {

    INSTANCE;

    public static InstanceOfRule getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean synchronize(WriteGraph graph, Resource template, Resource instance, TypicalInfo info) throws DatabaseException {
        boolean changed = false;
        Layer0 L0 = Layer0.getInstance(graph);
        Collection<Resource> templateInstanceOf = graph.getObjects(template, L0.InstanceOf);
        Collection<Resource> instanceInstanceOf = graph.getObjects(instance, L0.InstanceOf);

        for (Resource instanceOf : templateInstanceOf) {
            if (!graph.hasStatement(instance, L0.InstanceOf, instanceOf)) {
                graph.claim(instance, L0.InstanceOf, instanceOf);
                info.messageLog.add("\t\t\tadd type  " + NameUtils.getSafeName(graph, instanceOf));
                changed = true;
            }
        }
        for (Resource instanceOf : instanceInstanceOf) {
            if (!templateInstanceOf.contains(instanceOf) && graph.hasStatement(instance, L0.InstanceOf, instanceOf)) {
                graph.deny(instance, L0.InstanceOf, instanceOf);
                info.messageLog.add("\t\t\tremove type " + NameUtils.getSafeName(graph, instanceOf));
                changed = true;
            }
        }

        return changed;
    }

}
