package org.simantics.modeling.symbolEditor;

import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.utils.StructuralUtils;

public class PopulateTerminal {

    public static void addToGraph(WriteGraph g, Resource symbolDiagram, Resource relation, Resource terminal) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance(g);
        DiagramResource DIA = DiagramResource.getInstance(g);
        ModelingResources MOD = ModelingResources.getInstance(g);
        Layer0 L0 = Layer0.getInstance(g);

        Resource definedElement = g.getSingleObject(symbolDiagram, STR.Defines);

        // Check for existing terminal relation in
        // the current defined element before creating new ones.
        Resource terminalRelation = null;
        for (Resource terminalRel : StructuralUtils.getConnectionRelations(g, definedElement)) {
            for (Resource connectionRel : g.getObjects(terminalRel, MOD.DiagramConnectionRelationToConnectionRelation)) {
                if (relation.equals(connectionRel)) {
                    // Don't create new diagram-side terminal relation if one already
                    // exists for the same connection relation.
                    terminalRelation = terminalRel;
                    break;
                }
            }
        }

        if (terminalRelation == null) {
            terminalRelation = GraphUtils.create(g,
//                    L0.SubrelationOf, STR.IsConnectedTo,
                    MOD.DiagramConnectionRelationToConnectionRelation, relation,
                    L0.PartOf, definedElement
            );
            g.claim(terminalRelation, L0.SubrelationOf, null, STR.IsConnectedTo);
            Resource inverse = GraphUtils.create(g,
//                    L0.SubrelationOf, STR.Connects, 
                    L0.PartOf, terminalRelation, 
                    L0.HasName, "Inverse");
            g.claim(inverse, L0.SubrelationOf, null, STR.Connects);
            g.claim(terminalRelation, L0.InverseOf, inverse);
            String name = g.getPossibleRelatedValue(relation, L0.HasName, Bindings.STRING);
            if(name != null)
                g.claimLiteral(terminalRelation, L0.HasName, name);

            boolean interfaceGeneratesComponentExternally = !g.hasStatement(relation, MOD.GeneratesConnectionComponentInternally);
            for(Resource type : g.getObjects(relation, MOD.ImpliesDiagramConnectionRelationType)) {
                // #6636: Only instantiate type if it does not generate a component
                // when interface is marked to generate component internally.
                boolean shouldInstantiate = interfaceGeneratesComponentExternally || 
                        g.getAssertedObjects(type, MOD.DiagramConnectionRelationToComponentType).isEmpty();
                if (shouldInstantiate)
                    g.claim(terminalRelation, L0.InstanceOf, type);
            }

            StructuralUtils.addConnectionPoint(g, definedElement, terminalRelation);
        }

        g.claim(terminal, DIA.HasConnectionPoint, terminalRelation);
    }
	
}
