/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.subscription;

import java.util.List;

import org.simantics.databoard.util.Bean;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;

/**
 * This query returns all subscriptions and their corersponding names.
 *  
 * @author toni.kalajainen
 */
public class SubscriptionsQuery extends ResourceRead<SubscriptionsQuery.SubscriptionsResult> {

	public static class SubscriptionsResult extends Bean {
		
		public List<Resource> resources;
		public List<String> names;
		
		public String[] toNames() {
			return names.toArray( new String[names.size()] );
		}
		
		public String getName(Resource resource)
		{
			if (resource==null) return null;
			for ( int i=0; i<resources.size(); i++ ) {				
				if ( resource.equals( resources.get(i) ) ) return names.get(i);
			}
			return null;
		}
		
	}

	public SubscriptionsQuery(Resource resource) {
		super(resource);
	}


	@Override
	public SubscriptionsResult perform(ReadGraph graph) throws DatabaseException {
		Layer0 L0 = Layer0.getInstance(graph);
		ModelingResources MOD = ModelingResources.getInstance(graph);
		
		SubscriptionsResult result = new SubscriptionsResult();
		result.init();
		
    	for (Resource r : graph.getObjects(resource, L0.ConsistsOf)) {
    		if ( !graph.isInstanceOf(r, MOD.Subscription) ) continue;
    		String label = graph.getPossibleRelatedValue(r, L0.HasLabel);
    		result.resources.add( r );
    		result.names.add( label == null ? "" : label );
    	}
		
		return result;
	}
	
}
