/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.subscription;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;


/**
 * This query returns all subscription items for a collection of subscriptions. 
 */
public class SubscriptionItemsQuery extends UniqueRead<Set<Resource>> {

	Collection<Resource> resources;
	
    public SubscriptionItemsQuery(Collection<Resource> resources) {
        super();
        this.resources = resources;
    }

    @Override
    public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
        
    	Set<Resource> result = new HashSet<Resource>();
    	ModelingResources MOD = ModelingResources.getInstance(graph);
    	Layer0 L0 = Layer0.getInstance(graph);
    			
    	for (Resource r : resources) {
    		if ( graph.isInstanceOf(r, MOD.Subscription_Item)) result.add(r);
    		else if ( graph.isInstanceOf(r, MOD.Subscription)) {
    			for (Resource rr : graph.getObjects(r, L0.ConsistsOf)) {
    	    		if ( graph.isInstanceOf(rr, MOD.Subscription_Item)) result.add(rr);    				
    			}
    		}
    	}
    	
    	return result;
        
    }
}
