/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.subscription;

import java.util.UUID;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.modeling.ModelingResources;

public class NewSubscription extends WriteRequest {

	public Resource subscription;
	Resource model;
	String name;
	
	public NewSubscription( Resource model, String name ) {
		this.model = model;
		this.name = name;
	}
	
	@Override
	public void perform(WriteGraph g) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance(g);
        ModelingResources wr = ModelingResources.getInstance(g);
        String freshLabel = NameUtils.findFreshLabel(g, name, model);
        subscription = GraphUtils.create2(g, wr.Subscription,
                l0.HasName, UUID.randomUUID().toString(),
                l0.HasLabel, freshLabel,
                l0.PartOf, model);
        
        CommentMetadata cm = g.getMetadata(CommentMetadata.class);
        g.addMetadata(cm.add("Created subscription folder " + name));
	}
	
}