/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.subscription;

import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;

/**
 * This query finds subscription items by variable reference
 * 
 * @author toni.kalajainen
 */
public class FindSubscriptionItem extends UniqueRead<Resource> {

	Resource subscription;
	RVI rvi;
	
	public FindSubscriptionItem(Resource subscription, RVI rvi) {
		super();
		this.subscription = subscription;
		this.rvi = rvi;
	}

	@Override
	public Resource perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        ModelingResources MOD = ModelingResources.getInstance(graph);

    	Binding rviBinding = graph.getService(Databoard.class).getBindingUnchecked( RVI.class );
        for (Resource r : graph.getObjects(subscription, L0.ConsistsOf))
        {
        	if ( !graph.isInstanceOf(r, MOD.Subscription_Item) ) continue;
        	
        	RVI _rvi = (RVI) graph.getPossibleRelatedValue(r, MOD.Subscription_Item_VariableId, rviBinding);
        	if (_rvi.equals(rvi)) return r;
        }

		return null;
	}
	
    @Override
    public int hashCode() {
        return rvi.hashCode() + subscription.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) return true;
        if (object == null) return false;
        if (getClass() != object.getClass()) return false;
        FindSubscriptionItem r = (FindSubscriptionItem) object;
        
        return subscription.equals(r.subscription) && rvi.equals(r.rvi);
    }
	


}
