/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.subscription;

import java.util.Objects;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;

/**
 * This query finds subscription using label as keyword.
 * If multiple subscriptions have the 
 * 
 * @author toni.kalajainen
 */
public class FindSubscription extends UniqueRead<Resource> {

	Resource model;
	String id, label;
	
	public FindSubscription( Resource model, String id, String label )
	{
		this.model = model;
		this.id = id;
		this.label = label;
	}
	
	@Override
	public Resource perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        ModelingResources MOD = ModelingResources.getInstance(graph);

        for (Resource r : graph.getObjects(model, L0.ConsistsOf))
        {
        	if ( !graph.isInstanceOf(r, MOD.Subscription) ) continue;
        	
        	if ( this.id!=null ) {
            	String name = graph.getPossibleRelatedValue(r, L0.HasName);
            	if ( !name.equals(this.id)) continue;
        	}
        	
        	if ( this.label!=null ) {
            	String label = graph.getPossibleRelatedValue(r, L0.HasLabel);
            	if ( !label.equals(this.label)) continue;
        	}
        	
        	return r;
        }
        
		return null;
	}
	
    @Override
    public int hashCode() {
        return model.hashCode() + (id!=null?id.hashCode():0) + (label!=null?label.hashCode():0);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) return true;
        if (object == null) return false;
        if (getClass() != object.getClass()) return false;
        FindSubscription r = (FindSubscription) object;
        
        if ( !Objects.equals(id, r.id) ) return false;
        if ( !Objects.equals(label, r.label)) return false;
        
        return true;
    }
	

}
