package org.simantics.modeling.scl;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.NodeManagerVariableBuilder;
import org.simantics.db.layer0.variable.NodeSupport;

public class SCLVariableBuilder extends NodeManagerVariableBuilder {

	@Override
	protected NodeSupport<?> getNodeSupport(ReadGraph graph, String sessionName) throws DatabaseException {
        return SCLSessionManager.getOrCreateNodeSupport(sessionName);
	}
	
	@Override
	protected Object getRoot(ReadGraph graph, NodeSupport<?> support, String sessionName) {
		//CachingNodeManager<?> cnm = (CachingNodeManager<?>)support.manager;
		SCLNodeManager manager = (SCLNodeManager)support.manager;
		return manager.getRoot();
	}
	
}


//implements VariableBuilder {
//	
//    @Override
//    public Variable buildChild(ReadGraph graph, Variable parent, VariableNode node, Resource child) throws DatabaseException {
//    	Layer0 L0 = Layer0.getInstance(graph);
//    	String childName = graph.getRelatedValue(child, L0.HasName, Bindings.STRING);
//        String sessionName = parent.getURI(graph) + "/" + childName;
//        SCLRealm session = SCLSessionManager.sclRealmById(sessionName);
//        if(session == null) {
//        	session = SCLSessionManager.getOrCreateSCLRealm(sessionName);
//        }
//        return new StandardGraphChildVariable(parent, new VariableNode(new NodeSupport<String>(session.getNodeManager()), SCLNodeManager.ROOT), child);
//    }
//
//    @Override
//    public Variable buildProperty(ReadGraph graph, Variable parent, VariableNode node, Resource subject, Resource predicate) throws DatabaseException {
//        throw new UnsupportedOperationException();
//    }
//}
