/*******************************************************************************
 * Copyright (c) 2007, 2014 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - #5290
 *******************************************************************************/
package org.simantics.modeling.rules;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.structural2.modelingRules.IConnectionPoint;

/**
 * Abstraction of diagram to configuration mapping. 
 * @author Hannu Niemist
 */
public interface IMapping {
	IConnectionPoint mapConnectionPoint(ReadGraph g, IConnectionPoint cp) throws DatabaseException;	
	/**
	 * @param g database access handle
	 * @param cp diagram connection point to map to configuration
	 * @param result the collection to add the discovered connection points to
	 * @return the amount of connection points added to the result
	 * @throws DatabaseException
	 * @since 1.16, 1.13.3
	 */
	int mapToConnectionPoints(ReadGraph g, IConnectionPoint cp, Collection<IConnectionPoint> result) throws DatabaseException;	
	Resource mapComponentType(ReadGraph g, Resource componentType) throws DatabaseException;	
	Resource mapConnection(ReadGraph g, Resource connection) throws DatabaseException;
	Resource invMapConnection(WriteGraph g, Resource connection) throws DatabaseException;
	Resource mapConnectionRelation(ReadGraph g, Resource relation) throws DatabaseException;
	Resource mapComponent(ReadGraph g, Resource component) throws DatabaseException;	
}
