package org.simantics.modeling.query;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ProxyChildVariable;
import org.simantics.db.layer0.variable.Variable;

public class QueryProxyChildVariable extends ProxyChildVariable {

    public QueryProxyChildVariable(Variable base, Variable parent, Variable other, String name) {
        super(base, parent, other, name);
    }

    @Override
    public Variable create(Variable base, Variable parent, Variable other, String name) {
        return new QueryProxyChildVariable(base, parent, other, name);
    }
    
    public Variable getPossibleChild(ReadGraph graph, String name) throws DatabaseException {
        
    	if(CONTEXT_END.equals(name)) {
        	if(other instanceof ProxyChildVariable) {
        		// The context is also a proxy - let it do the job
                return super.getPossibleChild(graph, name);
        	} else {
            	return new QueryRootVariable(this, base.getRepresents(graph));
        	}
    	}
        
        return super.getPossibleChild(graph, name);
        
    }
    
    public Collection<Variable> getChildren(ReadGraph graph) throws DatabaseException {

        Collection<Variable> result = super.getChildren(graph);
        if(!(base instanceof ProxyChildVariable)) {
        	result.add(new QueryRootVariable(this, base.getRepresents(graph)));
        }
        return result;
        
    }       
    
}