/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.Preferences;

/**
 * @author Toni Kalajainen
 */
public class SubscriptionPreferenceInitializer extends AbstractPreferenceInitializer {

    public void initializeDefaultPreferences() {
        IScopeContext context = DefaultScope.INSTANCE;
        Preferences node = context.getNode(SubscriptionPreferences.P_NODE);
        node.putDouble(SubscriptionPreferences.P_SUBSCRIPTION_INTERVAL, SubscriptionPreferences.DEFAULT_SUBSCRIPTION_INTERVAL);
        node.putDouble(SubscriptionPreferences.P_SUBSCRIPTION_DEADBAND, SubscriptionPreferences.DEFAULT_SUBSCRIPTION_DEADBAND);
        node.putDouble(SubscriptionPreferences.P_SUBSCRIPTION_BIAS, SubscriptionPreferences.DEFAULT_SUBSCRIPTION_BIAS);
        node.putDouble(SubscriptionPreferences.P_SUBSCRIPTION_GAIN, SubscriptionPreferences.DEFAULT_SUBSCRIPTION_GAIN);
        node.putBoolean(SubscriptionPreferences.P_SUBSCRIPTION_SHOW_VALUE_IN_MODEL_BROWSER, SubscriptionPreferences.DEFAULT_SHOW_VALUE_IN_MODEL_BROWSER);
    }

}
