/*******************************************************************************
 * Copyright (c) 2022 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.preferences;

import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;

/**
 * @author Tuukka Lehtonen
 * @since 1.51.0
 */
public class SCLIssuePreferences {

	public static final String P_NODE = "org.simantics.modeling";

	/**
	 * Name of system property that can be used to set the default value of
	 * {@link #P_SCL_EXPRESSION_ISSUES_ENABLED}.
	 */
	public static final String PROP_SCL_EXPRESSION_ISSUES_ENABLED = "org.simantics.scl.issues.expression.enabled"; //$NON-NLS-1$

	public static final String P_SCL_EXPRESSION_ISSUES_ENABLED = "scl.expressionIssues.enabled"; //$NON-NLS-1$

	public static final boolean DEFAULT_SCL_EXPRESSION_ISSUES_ENABLED = false;

	public static boolean expressionIssuesEnabled() {
		Preferences defaults = DefaultScope.INSTANCE.getNode(SCLIssuePreferences.P_NODE);
		Preferences instance = InstanceScope.INSTANCE.getNode(SCLIssuePreferences.P_NODE);
		boolean defaultValue = defaults.getBoolean(SCLIssuePreferences.P_SCL_EXPRESSION_ISSUES_ENABLED, DEFAULT_SCL_EXPRESSION_ISSUES_ENABLED);
		return instance.getBoolean(SCLIssuePreferences.P_SCL_EXPRESSION_ISSUES_ENABLED, defaultValue);
	}

}