/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.preferences;

import org.simantics.history.csv.ExportInterpolation;

/**
 * TODO: duplicate of org.simantics.simulation.export. Reorganize to remove duplication.
 */
public class CSVPreferences {

	public static final String P_NODE                       = "org.simantics.modeling";

	// Comma separated value
	public static final String P_CSV_DECIMAL_SEPARATOR      = "csv.decimal.separator";      //$NON-NLS-1$
	public static final String P_CSV_FILE_EXTENSION         = "csv.file.extension";         //$NON-NLS-1$
	public static final String P_CSV_COLUMN_SEPARATOR       = "csv.value.separator";        //$NON-NLS-1$
	public static final String P_CSV_START_TIME             = "csv.start";                   //$NON-NLS-1$
	public static final String P_CSV_TIME_STEP              = "csv.step";                   //$NON-NLS-1$
	
	public static final String P_CSV_RESAMPLE               = "csv.resample";                   //$NON-NLS-1$
	public static final String P_CSV_SAMPLING_MODE          = "csv.sampling.mode";                   //$NON-NLS-1$

	public static final String P_CSV_TIME_DIGITS            = "csv.format.time.digits";     //$NON-NLS-1$
	public static final String P_CSV_FLOAT_DIGITS           = "csv.format.float.digits";    //$NON-NLS-1$
	public static final String P_CSV_DOUBLE_DIGITS          = "csv.format.double.digits";   //$NON-NLS-1$

	public static final String P_CSV_OUTPUT_ENCODING        = "csv.output.encoding";   //$NON-NLS-1$

	public static final Double DEFAULT_CSV_START_TIME       = 0.0; // seconds
	public static final Double DEFAULT_CSV_TIME_STEP        = 1.0; // seconds
	public static final String DEFAULT_FILE_EXTENSION       = ".txt";
	
	public static final Boolean DEFAULT_CSV_RESAMPLE        = true;
	public static final String DEFAULT_CSV_SAMPLING_MODE    = ExportInterpolation.getDefault().toPreference();

	public static final int    DEFAULT_CSV_TIME_DIGITS      = 9; // From MathContext#DEFAULT_DIGITS
	public static final int    DEFAULT_CSV_FLOAT_DIGITS     = 7;
	public static final int    DEFAULT_CSV_DOUBLE_DIGITS    = 15;

}
