/*******************************************************************************
 * Copyright (c) 2018 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ContextualRelatedValue;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.structural2.scl.CompileStructuralValueRequest;

/**
 * @author Antti Villberg
 * @since 1.36.0
 */
public class SCLComputationalValue extends ContextualRelatedValue {

    @Override
    public Function1<Object,Object> getFunction(ReadGraph graph, Resource s, Resource o, Resource p) throws DatabaseException {
        return CompileStructuralValueRequest.compile(graph, s, o, p);
    }

}