package org.simantics.modeling;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.SimanticsPlatform;
import org.simantics.SimanticsPlatform.OntologyRecoveryPolicy;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.external.EclipsePreferencePrimitiveRead;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.service.DebugSupport;
import org.simantics.db.service.ServiceActivityMonitor;
import org.simantics.scl.db.SCLFunctions;
import org.simantics.scl.runtime.SCLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCL {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCL.class);

    public static void killPlatformWrite(WriteGraph graph) throws DatabaseException {
        // Currently not supported.
        // Would be relatively easy to support the desired functionality.
        // To implement this I would recommend something like:
        // SimanticsPlatform.INSTANCE.breakWrite();
        // And it's implementation with db.management.breakWrite() method.
        // To be clear, at the moment this method (breakWrite) does not exist.
    }
    public static void killPlatformRead(ReadGraph graph) throws DatabaseException {
        // See above.
    }
    public static void killPlatform() throws Exception {
        SimanticsPlatform.INSTANCE.shutdown(null);
    }
    public static void shutdownPlatform() throws Exception {
        SimanticsPlatform.INSTANCE.shutdown(null);
    }
    public static void reconnectPlatform() throws Exception {
        SimanticsPlatform.INSTANCE.reconnect(Simantics.getDefaultDatabaseDriver());
    }
    public static void synchronizeOntologies() throws Exception {
    	SimanticsPlatform.INSTANCE.synchronizeOntologies(new NullProgressMonitor(), OntologyRecoveryPolicy.Merge, true);
    	Simantics.getSession().getService(DebugSupport.class).query(Simantics.getSession(), "exec QueryControl.flush");
    }

    public static void sync() throws DatabaseException {
    	// Multiple bugs here:
    	// -Model performs activation in separate write transactions because API does not support changing the virtual graph
    	//  => activation & activation listener is delayed beyond this point
    	// -This should be fixed by the following code
        //     TransactionSupport ts = session.getService(TransactionSupport.class);
    	//     ts.waitCompletion();
    	//  but unfortunately this does not work either...
    	// so we synchronize by a familiar write transaction
        // And then wait still some more
//		for(int i=0;i<3;i++) {
       Simantics.getSession().syncRequest(new WriteRequest() {
            @Override
            public void perform(WriteGraph graph) throws DatabaseException {
            }

        	@Override
        	public String toString() {
        		return "Utils sync";
        	}
       });
//
//	       // And then wait still some more
//	       Simantics.getSession().syncRequest(new ReadRequest() {
//	           @Override
//	           public void run(ReadGraph graph) throws DatabaseException {
//	           }
//	      });
//		}
    }

    public static void syncGraph() throws Exception {
    	
        final SCLContext context = SCLContext.getCurrent();
        Object graph = context.get(SCLFunctions.GRAPH);
        if (graph != null)
        	throw new IllegalStateException("Already in transaction");
    	
        try {
            Simantics.getSession().getService(ServiceActivityMonitor.class).waitForCompletion();
        } catch (InterruptedException e) {
            throw new DatabaseException(e);
        }

		// OK, now the experiment activate job should be scheduled
		// Wait for the job to finish
        IJobManager job = Job.getJobManager();
        Job[] jobs = job.find(null);
        for (Job j : jobs) {
            if(j instanceof DatabaseJob) j.join();
        }
        sync();
	}

    public static boolean deleteMBNode(List<Resource> resources) throws DatabaseException {
    	boolean value = false;
		try {
    		value = RemoverUtil.tryCollectionRemover(resources);
    	} catch (DatabaseException e){
    		return value;
    	}
    	return value;
    }

    public static void sleep(int ms) {
    	try {
			Thread.sleep(ms);
		} catch (InterruptedException e) {
            LOGGER.warn("Sleep was interrupted.", e);
		}
    }

    public static boolean hasSomethingToPaste(ReadGraph graph, Resource resource) throws DatabaseException {

    	SimanticsClipboard clipboard = Simantics.getClipboard();
    	return !clipboard.getContents().isEmpty();

    }
    
    public static boolean canDelete(ReadGraph graph, Resource resource) throws DatabaseException {

    	return RemoverUtil.canRemove(graph, resource);

    }

    public static boolean canRename(ReadGraph graph, Resource resource) throws DatabaseException {
    	return true;
    }

    public static String currentDate(String format) {

       	SimpleDateFormat sdf = new SimpleDateFormat(format);
       	return sdf.format(new Date(System.currentTimeMillis()));

    }

    public static File workspaceDirectory() {
    	return new File(Platform.getInstanceLocation().getURL().getFile());
    }
    
    public static String queryPreference(ReadGraph graph, String pluginId, String preferenceKey) throws DatabaseException {
    	String result = graph.syncRequest(new EclipsePreferencePrimitiveRead(pluginId, preferenceKey));
    	if(result == null) return "";
        return result;
    }

    
}
