package org.simantics.modeling;

import java.util.UUID;

import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.layer0.Layer0;
import org.simantics.project.exception.ProjectException;
import org.simantics.project.features.AbstractProjectFeature;

public class ProjectSCLFeature extends AbstractProjectFeature {

	@Override
	public void configure() throws ProjectException {
		
		try {
			
	        final Session session = getSession();
	        final VirtualGraphSupport support = session.getService(VirtualGraphSupport.class);
	        support.getWorkspacePersistent("documentation");

			Simantics.getSession().syncRequest(new WriteRequest() {

				@Override
				public void perform(WriteGraph graph) throws DatabaseException {
					
					Resource project = Simantics.getProjectResource();
					Resource commandSession = Layer0Utils.getPossibleChild(graph, project, "__scl__");
					if(commandSession == null) {
						Layer0 L0 = Layer0.getInstance(graph);
						ModelingResources MOD = ModelingResources.getInstance(graph);
						commandSession = graph.newResource();
						graph.claim(commandSession, L0.InstanceOf, MOD.SCLCommandSession);
						graph.claimLiteral(commandSession, L0.HasName, L0.NameOf, L0.String, "__scl__", Bindings.STRING);
						graph.claim(project, L0.ConsistsOf, commandSession);
					}
					
				}
				
			});
			
		} catch (DatabaseException e) {
			
			throw new ProjectException(e);
			
		}
		
	}

	@Override
	public void deconfigure() throws ProjectException {
		
	}
   	
}
