package org.simantics.modeling;

import java.util.Arrays;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartialIC {

    private static final Logger LOGGER = LoggerFactory.getLogger(PartialIC.class);
	public static Binding BINDING = Bindings.getBindingUnchecked(PartialIC.class);
	
	public RVI[] rvis = {};
	public Variant[] variants = {};
	
	//public TreeMap<RVI, Variant> values = new TreeMap<RVI, Variant>(); 
	
	public void add(RVI rvi, Variant value) {
	    rvis = Arrays.copyOf(rvis, rvis.length + 1);
	    rvis[rvis.length - 1] = rvi;
	    variants = Arrays.copyOf(variants, variants.length + 1);
        variants[rvis.length - 1] = value;
        
		//values.put(rvi, value);
	}
	
	public void apply(WriteGraph graph, Variable base) throws DatabaseException {
//		for(Map.Entry<RVI,Variant> entry : values.entrySet()) {
//			RVI rvi = entry.getKey();
//			Variant variant = entry.getValue();
//			Variable v = rvi.resolvePossible(graph, base);
//			if(v != null) {
////				LOGGER.warn("apply " + v.getURI(graph) + " => " + variant);
//				v.setValue(graph, variant.getValue(), variant.getBinding());
//			} else {
//				LOGGER.warn("failed to resolve " + rvi);
//			}
//		}
	    
	    if (rvis.length != variants.length) {
	        throw new DatabaseException("PartialIC has broken RVI and Variant data arrays. Tried to apply to " + base.getURI(graph));
	    }
	    
	    for (int i = 0; i < rvis.length; i++) {
	        RVI rvi = rvis[i];
	        Variant variant = variants[i];
	        Variable v = rvi.resolvePossible(graph, base);
	        if (v != null) {
//              LOGGER.warn("apply " + v.getURI(graph) + " => " + variant);
                v.setValue(graph, variant.getValue(), variant.getBinding());
            } else {
                LOGGER.warn("failed to resolve " + rvi);
            }
        }
	    
	}
	
}
