package org.simantics.modeling;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;

/**
 * @author Tuukka Lehtonen
 */
public class NewSymbol {

	public static Resource createSymbol(WriteGraph graph, Resource componentType) throws DatabaseException {

		ModelingResources MOD = ModelingResources.getInstance(graph);
		Layer0 L0 = Layer0.getInstance(graph);
		DiagramResource DIA = DiagramResource.getInstance(graph);

		// New component type
		CommonDBUtils.selectClusterSet(graph, componentType);

		Resource indexRoot = graph.sync(new PossibleIndexRoot(componentType));

		Resource symbolDiagramType = graph.getPossibleObject(indexRoot, MOD.StructuralModel_HasSymbolDiagramType);
		if(symbolDiagramType == null) symbolDiagramType = DIA.Composite;

		// Symbol
		String symbolName = NameUtils.findFreshName(graph, "Symbol", componentType);
		Resource symbol = new ModelingUtils(graph).createSymbol2(symbolName, symbolDiagramType);
		graph.claim(componentType, MOD.ComponentTypeToSymbol, symbol);
		graph.claim(componentType, L0.ConsistsOf, symbol);

		CommentMetadata cm = graph.getMetadata(CommentMetadata.class);
		graph.addMetadata(cm.add("Created new user component symbol " + symbolName + ", resource " + symbol));

		return componentType;
	}

}