/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.properties;

import org.eclipse.jface.viewers.ISelection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.selectionview.PropertyTabContributorImpl;
import org.simantics.utils.ui.AdaptionUtils;

public abstract class LabelPropertyTabContributor
extends PropertyTabContributorImpl {
    protected final Object id;

    public LabelPropertyTabContributor(Object id) {
        assert (id != null);
        this.id = id;
    }

    public Read<String> getPartNameReadRequest(final ISelection forSelection) {
        return new Read<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                String label;
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
                Variable variable = (Variable)AdaptionUtils.adaptToSingle((Object)forSelection, Variable.class);
                Resource resource = (Resource)AdaptionUtils.adaptToSingle((Object)forSelection, Resource.class);
                if (resource == null && variable == null) {
                    return "Selection";
                }
                Resource r = variable != null ? variable.getRepresents(graph) : resource;
                if (graph.hasStatement(r, mr.ElementToComponent)) {
                    r = graph.getSingleObject(r, mr.ElementToComponent);
                }
                if ((label = (String)graph.getPossibleRelatedValue(r, l0.HasLabel)) != null) {
                    return label;
                }
                label = (String)graph.getPossibleRelatedValue(r, l0.HasName);
                if (label != null) {
                    return label;
                }
                return "No name for selection";
            }
        };
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        LabelPropertyTabContributor other = (LabelPropertyTabContributor)((Object)obj);
        return this.id.equals(other.id);
    }
}

