/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart;

import java.util.List;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.simantics.jfreechart.chart.FilteredDataset;

public class FilteringPieDataset
extends AbstractDataset
implements PieDataset,
FilteredDataset {
    private static final long serialVersionUID = -4955124650051030544L;
    PieDataset original;
    DefaultPieDataset filtered;
    PieDataset used;
    boolean filtering = true;
    double filterFraction = 0.05;
    private Comparable other = "other";

    public FilteringPieDataset(PieDataset dataset, Comparable other) {
        this.original = dataset;
        this.filtered = new DefaultPieDataset();
        this.other = other;
        this.used = this.filtered;
        this.updateFiltered();
    }

    @Override
    public boolean isFiltering() {
        return this.filtering;
    }

    @Override
    public void setFiltering(boolean filtering) {
        this.filtering = filtering;
        this.used = filtering ? this.filtered : this.original;
        this.fireDatasetChanged();
    }

    @Override
    public void setFilterFraction(double filterFraction) {
        this.filterFraction = filterFraction;
    }

    @Override
    public double getFilterFraction() {
        return this.filterFraction;
    }

    @Override
    public void updateFiltered() {
        this.filtered.clear();
        Double total = 0.0;
        Double other = 0.0;
        for (Object key : this.original.getKeys()) {
            total = total + this.original.getValue((Comparable)key).doubleValue();
        }
        total = total * this.filterFraction;
        for (Object key : this.original.getKeys()) {
            Double value = this.original.getValue((Comparable)key).doubleValue();
            if (value > total) {
                this.filtered.setValue((Comparable)key, (Number)value);
                continue;
            }
            other = other + value;
        }
        if (other > 0.0) {
            this.filtered.setValue(this.other, (Number)other);
        }
        this.fireDatasetChanged();
    }

    public List getKeys() {
        return this.used.getKeys();
    }

    public int getItemCount() {
        return this.used.getItemCount();
    }

    public Comparable getKey(int index) {
        return this.used.getKey(index);
    }

    public int getIndex(Comparable key) {
        return this.used.getIndex(key);
    }

    public Number getValue(Comparable key) {
        return this.used.getValue(key);
    }

    public Number getValue(int index) {
        return this.used.getValue(index);
    }

    @Override
    public Comparable getOther() {
        return this.other;
    }
}

