/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart;

import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.axis.Axis;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.G2DUtils;
import org.simantics.jfreechart.chart.IAxis;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.JFreeChartResource;

public abstract class AbstractAxis
implements IAxis {
    protected Axis axis;
    protected String label;
    protected Boolean tMarksVisible;
    protected Boolean tLabelsVisible;
    protected Boolean labelVisible;
    protected Boolean lineVisible;
    protected Color color;
    protected Double min;
    protected Double max;
    protected Double rotate;

    public AbstractAxis(ReadGraph graph, Resource axisResource) {
        try {
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
            this.label = (String)graph.getPossibleRelatedValue(axisResource, l0.HasLabel);
            this.tMarksVisible = (Boolean)graph.getPossibleRelatedValue(axisResource, jfree.Axis_visibleTickMarks, (Binding)Bindings.BOOLEAN);
            this.tLabelsVisible = (Boolean)graph.getPossibleRelatedValue(axisResource, jfree.Axis_visibleTickLabels, (Binding)Bindings.BOOLEAN);
            this.labelVisible = (Boolean)graph.getPossibleRelatedValue(axisResource, jfree.Axis_visibleLabel, (Binding)Bindings.BOOLEAN);
            this.lineVisible = (Boolean)graph.getPossibleRelatedValue(axisResource, jfree.Axis_visibleAxisLine, (Binding)Bindings.BOOLEAN);
            Resource c = graph.getPossibleObject(axisResource, jfree.color);
            this.color = c == null ? null : G2DUtils.getColor((ReadGraph)graph, (Resource)c);
            this.min = (Double)graph.getPossibleRelatedValue(axisResource, jfree.Axis_min, (Binding)Bindings.DOUBLE);
            this.max = (Double)graph.getPossibleRelatedValue(axisResource, jfree.Axis_max, (Binding)Bindings.DOUBLE);
            this.rotate = (Double)graph.getPossibleRelatedValue(axisResource, jfree.Axis_rotateLabelDegrees, (Binding)Bindings.DOUBLE);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public Axis getAxis() {
        if (this.tMarksVisible != null && !this.tMarksVisible.booleanValue()) {
            this.axis.setTickMarksVisible(false);
        }
        if (this.tLabelsVisible != null && !this.tLabelsVisible.booleanValue()) {
            this.axis.setTickLabelsVisible(false);
        }
        if (this.lineVisible != null && !this.lineVisible.booleanValue()) {
            this.axis.setAxisLineVisible(false);
        }
        if (this.color != null) {
            this.axis.setAxisLinePaint((Paint)this.color);
            this.axis.setLabelPaint((Paint)this.color);
            this.axis.setTickLabelPaint((Paint)this.color);
            this.axis.setTickMarkPaint((Paint)this.color);
        }
        if ((this.labelVisible == null || this.labelVisible.booleanValue()) && this.label != null) {
            this.axis.setLabel(this.label);
        }
        return this.axis;
    }
}

